/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari.compat.cbc;

import com.mojang.logging.LogUtils;
import com.vibey.imitari.api.ICopyBlock;
import com.vibey.imitari.api.blockentity.ICopyBlockEntity;
import com.vibey.imitari.registry.ModBlocks;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesHandler;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesSerializer;
import rbasamoyai.createbigcannons.block_armor_properties.mimicking_blocks.AbstractMimickingBlockArmorProperties;
import rbasamoyai.createbigcannons.block_armor_properties.mimicking_blocks.MimickingBlockArmorUnit;

public class CBCIntegrationImpl {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void register() {
        CBCIntegrationImpl.registerCopyBlock((Block)ModBlocks.COPY_BLOCK.get());
        CBCIntegrationImpl.registerCopyBlock((Block)ModBlocks.COPY_BLOCK_GHOST.get());
        CBCIntegrationImpl.registerCopyBlock((Block)ModBlocks.COPY_BLOCK_SLAB.get());
        CBCIntegrationImpl.registerCopyBlock((Block)ModBlocks.COPY_BLOCK_STAIRS.get());
        CBCIntegrationImpl.registerCopyBlock((Block)ModBlocks.COPY_BLOCK_LAYER.get());
        CBCIntegrationImpl.registerCopyBlock((Block)ModBlocks.COPY_BLOCK_FENCE.get());
        CBCIntegrationImpl.registerCopyBlock((Block)ModBlocks.COPY_BLOCK_FENCE_GATE.get());
        CBCIntegrationImpl.registerCopyBlock((Block)ModBlocks.COPY_BLOCK_WALL.get());
        CBCIntegrationImpl.registerCopyBlock((Block)ModBlocks.COPY_BLOCK_DOOR.get());
        CBCIntegrationImpl.registerCopyBlock((Block)ModBlocks.COPY_BLOCK_IRON_DOOR.get());
        CBCIntegrationImpl.registerCopyBlock((Block)ModBlocks.COPY_BLOCK_TRAPDOOR.get());
        CBCIntegrationImpl.registerCopyBlock((Block)ModBlocks.COPY_BLOCK_IRON_TRAPDOOR.get());
        CBCIntegrationImpl.registerCopyBlock((Block)ModBlocks.COPY_BLOCK_PANE.get());
        CBCIntegrationImpl.registerCopyBlock((Block)ModBlocks.COPY_BLOCK_BUTTON.get());
        CBCIntegrationImpl.registerCopyBlock((Block)ModBlocks.COPY_BLOCK_LEVER.get());
        CBCIntegrationImpl.registerCopyBlock((Block)ModBlocks.COPY_BLOCK_PRESSURE_PLATE.get());
        CBCIntegrationImpl.registerCopyBlock((Block)ModBlocks.COPY_BLOCK_LADDER.get());
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, false, AddReloadListenerEvent.class, CBCIntegrationImpl::onDataReload);
        LOGGER.info("CBC integration: Custom serializers registered");
    }

    private static void registerCopyBlock(Block block) {
        if (!(block instanceof ICopyBlock)) {
            return;
        }
        BlockArmorPropertiesHandler.registerCustomSerializer((Block)block, (BlockArmorPropertiesSerializer)AbstractMimickingBlockArmorProperties.createMimicrySerializer((defaultUnit, unitsByState) -> new ImitariCopyBlockArmorProperties((MimickingBlockArmorUnit)defaultUnit, (Map<BlockState, MimickingBlockArmorUnit>)unitsByState)));
    }

    public static void onDataReload(AddReloadListenerEvent event) {
        event.addListener((synchronizer, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> synchronizer.m_6769_(null).thenRunAsync(() -> CBCIntegrationImpl.injectCopyBlocksIntoBlockMap(), gameExecutor));
    }

    private static void injectCopyBlocksIntoBlockMap() {
        try {
            Field blockMapField = BlockArmorPropertiesHandler.class.getDeclaredField("BLOCK_MAP");
            blockMapField.setAccessible(true);
            Map blockMap = (Map)blockMapField.get(null);
            int injected = 0;
            for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
                Block block = (Block)entry.getValue();
                if (!(block instanceof ICopyBlock) || blockMap.containsKey(block)) continue;
                MimickingBlockArmorUnit defaultUnit = new MimickingBlockArmorUnit(1.0, 1.0, 0.5, 1.0);
                ImitariCopyBlockArmorProperties properties = new ImitariCopyBlockArmorProperties(defaultUnit, new HashMap<BlockState, MimickingBlockArmorUnit>());
                blockMap.put(block, properties);
                ++injected;
            }
            LOGGER.info("CBC integration: Injected {} CopyBlocks into BLOCK_MAP", (Object)injected);
        }
        catch (Exception e) {
            LOGGER.error("CBC integration: Failed to inject CopyBlocks into BLOCK_MAP", (Throwable)e);
        }
    }

    public static class ImitariCopyBlockArmorProperties
    extends AbstractMimickingBlockArmorProperties {
        public ImitariCopyBlockArmorProperties(MimickingBlockArmorUnit defaultUnit, Map<BlockState, MimickingBlockArmorUnit> unitsByState) {
            super(defaultUnit, unitsByState);
        }

        protected BlockState getCopiedState(Level level, BlockState state, BlockPos pos) {
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof ICopyBlockEntity) {
                ICopyBlockEntity copyBE = (ICopyBlockEntity)be;
                return copyBE.getCopiedBlock();
            }
            return Blocks.f_50016_.m_49966_();
        }

        protected boolean isEmptyState(Level level, BlockState copiedState, BlockState state, BlockPos pos) {
            return copiedState == null || copiedState.m_60795_();
        }

        public double hardness(Level level, BlockState state, BlockPos pos, boolean recurse) {
            BlockState copiedState = this.getCopiedState(level, state, pos);
            if (this.isEmptyState(level, copiedState, state, pos)) {
                return this.getDefaultProperties().emptyHardness();
            }
            if (copiedState.m_60800_((BlockGetter)level, pos) == -1.0f) {
                return 1000.0;
            }
            float effectiveMultiplier = this.getEffectiveMassMultiplier(state);
            double copiedHardness = BlockArmorPropertiesHandler.getProperties((BlockState)copiedState).hardness(level, copiedState, pos, false);
            return copiedHardness * (double)effectiveMultiplier;
        }

        public double toughness(Level level, BlockState state, BlockPos pos, boolean recurse) {
            BlockState copiedState = this.getCopiedState(level, state, pos);
            if (this.isEmptyState(level, copiedState, state, pos)) {
                return this.getDefaultProperties().emptyToughness();
            }
            if (copiedState.m_60800_((BlockGetter)level, pos) == -1.0f) {
                return copiedState.m_60734_().m_7325_();
            }
            float effectiveMultiplier = this.getEffectiveMassMultiplier(state);
            double copiedToughness = BlockArmorPropertiesHandler.getProperties((BlockState)copiedState).toughness(level, copiedState, pos, false);
            return copiedToughness * (double)effectiveMultiplier;
        }

        private float getEffectiveMassMultiplier(BlockState state) {
            Block block = state.m_60734_();
            if (!(block instanceof ICopyBlock)) {
                return 1.0f;
            }
            ICopyBlock copyBlock = (ICopyBlock)block;
            try {
                Method method = block.getClass().getMethod("getEffectiveMassMultiplier", BlockState.class);
                Object result = method.invoke((Object)block, state);
                if (result instanceof Float) {
                    return ((Float)result).floatValue();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            return copyBlock.getMassMultiplier();
        }
    }
}

