/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari.compat.vs2;

import com.mojang.logging.LogUtils;
import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import org.slf4j.Logger;

public class VS2CopyBlockIntegration {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static boolean VS2_LOADED = false;
    private static boolean CHECKED = false;
    private static boolean INTEGRATION_FAILED = false;

    public static boolean isAvailable() {
        if (!CHECKED) {
            VS2CopyBlockIntegration.checkVS2();
        }
        return VS2_LOADED && !INTEGRATION_FAILED;
    }

    private static void checkVS2() {
        if (CHECKED) {
            return;
        }
        VS2_LOADED = ModList.get().isLoaded("valkyrienskies");
        CHECKED = true;
        if (VS2_LOADED) {
            LOGGER.info("Valkyrien Skies 2 detected - enabling physics integration");
        }
    }

    public static void register() {
        if (!VS2CopyBlockIntegration.isAvailable()) {
            return;
        }
        try {
            Class<?> implClass = Class.forName("com.vibey.imitari.compat.vs2.VS2CopyBlockIntegrationImpl");
            Method registerMethod = implClass.getMethod("register", new Class[0]);
            registerMethod.invoke(null, new Object[0]);
            LOGGER.info("VS2 integration registered successfully");
        }
        catch (Exception e) {
            LOGGER.error("Failed to register VS2 integration", (Throwable)e);
            INTEGRATION_FAILED = true;
        }
    }

    public static void updateCopyBlockMass(Level level, BlockPos pos, BlockState copyBlockState, BlockState oldCopiedBlock) {
        if (!VS2CopyBlockIntegration.isAvailable()) {
            return;
        }
        try {
            Class<?> implClass = Class.forName("com.vibey.imitari.compat.vs2.VS2CopyBlockIntegrationImpl");
            Method method = implClass.getMethod("updateCopyBlockMass", Level.class, BlockPos.class, BlockState.class, BlockState.class);
            method.invoke(null, level, pos, copyBlockState, oldCopiedBlock);
        }
        catch (Exception e) {
            LOGGER.error("Failed to update VS2 copy block mass", (Throwable)e);
        }
    }

    public static void onBlockEntityDataLoaded(Level level, BlockPos pos, BlockState state, BlockState copiedBlock) {
        if (!VS2CopyBlockIntegration.isAvailable()) {
            return;
        }
        try {
            Class<?> implClass = Class.forName("com.vibey.imitari.compat.vs2.VS2CopyBlockIntegrationImpl");
            Method method = implClass.getMethod("onBlockEntityDataLoaded", Level.class, BlockPos.class, BlockState.class, BlockState.class);
            method.invoke(null, level, pos, state, copiedBlock);
        }
        catch (Exception e) {
            LOGGER.error("Failed to notify VS2 of block entity data load", (Throwable)e);
        }
    }

    public static void onBlockStateChanged(Level level, BlockPos pos, BlockState oldState, BlockState newState) {
        if (!VS2CopyBlockIntegration.isAvailable()) {
            return;
        }
        try {
            Class<?> implClass = Class.forName("com.vibey.imitari.compat.vs2.VS2CopyBlockIntegrationImpl");
            Method method = implClass.getMethod("onBlockStateChanged", Level.class, BlockPos.class, BlockState.class, BlockState.class);
            method.invoke(null, level, pos, oldState, newState);
        }
        catch (Exception e) {
            LOGGER.error("Failed to notify VS2 of block state change", (Throwable)e);
        }
    }

    public static void onBlockRemoved(Level level, BlockPos pos, BlockState state, BlockState copiedBlock) {
        if (!VS2CopyBlockIntegration.isAvailable()) {
            return;
        }
        try {
            Class<?> implClass = Class.forName("com.vibey.imitari.compat.vs2.VS2CopyBlockIntegrationImpl");
            Method method = implClass.getMethod("onBlockRemoved", Level.class, BlockPos.class, BlockState.class, BlockState.class);
            method.invoke(null, level, pos, state, copiedBlock);
        }
        catch (Exception e) {
            LOGGER.error("Failed to notify VS2 of block removal", (Throwable)e);
        }
    }
}

