/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari.compat.vs2;

import com.vibey.imitari.api.ICopyBlock;
import com.vibey.imitari.api.blockentity.ICopyBlockEntity;
import com.vibey.imitari.block.CopyBlockLayer;
import kotlin.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.internal.world.VsiShipWorld;
import org.valkyrienskies.core.internal.world.chunks.VsiBlockType;
import org.valkyrienskies.mod.common.BlockStateInfo;
import org.valkyrienskies.mod.common.BlockStateInfoProvider;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class VS2CopyBlockIntegrationImpl
implements BlockStateInfoProvider {
    public static final VS2CopyBlockIntegrationImpl INSTANCE = new VS2CopyBlockIntegrationImpl();
    private static final double EMPTY_COPY_BLOCK_MASS = 10.0;
    private static final ThreadLocal<Context> CURRENT_CONTEXT = new ThreadLocal();

    public int getPriority() {
        return 200;
    }

    @Nullable
    public Double getBlockStateMass(BlockState blockState) {
        Block block = blockState.m_60734_();
        if (!(block instanceof ICopyBlock)) {
            return null;
        }
        ICopyBlock copyBlock = (ICopyBlock)block;
        if (!copyBlock.useDynamicMass()) {
            return null;
        }
        Context ctx = CURRENT_CONTEXT.get();
        if (ctx == null) {
            return 10.0;
        }
        BlockEntity be = ctx.level.m_7702_(ctx.pos);
        if (!(be instanceof ICopyBlockEntity)) {
            return 10.0;
        }
        ICopyBlockEntity copyBE = (ICopyBlockEntity)be;
        BlockState copiedBlock = copyBE.getCopiedBlock();
        if (copiedBlock == null || copiedBlock.m_60795_()) {
            return 10.0;
        }
        Pair copiedInfo = BlockStateInfo.INSTANCE.get(copiedBlock);
        double copiedMass = copiedInfo != null && copiedInfo.getFirst() != null ? (Double)copiedInfo.getFirst() : 50.0;
        float effectiveMultiplier = this.getEffectiveMassMultiplier(blockState, copyBlock);
        return copiedMass * (double)effectiveMultiplier;
    }

    private float getEffectiveMassMultiplier(BlockState state, ICopyBlock copyBlock) {
        SlabType slabType;
        if (copyBlock instanceof CopyBlockLayer) {
            CopyBlockLayer layerBlock = (CopyBlockLayer)copyBlock;
            return layerBlock.getEffectiveMassMultiplier(state);
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61397_) && (slabType = (SlabType)state.m_61143_((Property)BlockStateProperties.f_61397_)) == SlabType.DOUBLE) {
            return copyBlock.getMassMultiplier() * 2.0f;
        }
        return copyBlock.getMassMultiplier();
    }

    @Nullable
    public VsiBlockType getBlockStateType(BlockState blockState) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double getCurrentMass(Level level, BlockPos pos, BlockState state) {
        CURRENT_CONTEXT.set(new Context(level, pos));
        try {
            Double mass = INSTANCE.getBlockStateMass(state);
            double d = mass != null ? mass : 10.0;
            return d;
        }
        finally {
            CURRENT_CONTEXT.remove();
        }
    }

    private static double calculateMassWithCopiedBlock(BlockState copyBlockState, BlockState copiedBlock, ICopyBlock copyBlock) {
        if (copiedBlock == null || copiedBlock.m_60795_()) {
            return 10.0;
        }
        Pair copiedInfo = BlockStateInfo.INSTANCE.get(copiedBlock);
        double copiedMass = copiedInfo != null && copiedInfo.getFirst() != null ? (Double)copiedInfo.getFirst() : 50.0;
        float effectiveMultiplier = INSTANCE.getEffectiveMassMultiplier(copyBlockState, copyBlock);
        return copiedMass * (double)effectiveMultiplier;
    }

    public static void updateCopyBlockMass(Level level, BlockPos pos, BlockState copyBlockState, BlockState oldCopiedBlock) {
        double newMass;
        if (level.f_46443_) {
            return;
        }
        Block block = copyBlockState.m_60734_();
        if (!(block instanceof ICopyBlock)) {
            return;
        }
        ICopyBlock copyBlock = (ICopyBlock)block;
        if (!copyBlock.useDynamicMass()) {
            return;
        }
        VsiShipWorld shipWorld = VSGameUtilsKt.getShipObjectWorld((Level)level);
        if (shipWorld == null) {
            return;
        }
        double oldMass = VS2CopyBlockIntegrationImpl.calculateMassWithCopiedBlock(copyBlockState, oldCopiedBlock, copyBlock);
        if (Math.abs(oldMass - (newMass = VS2CopyBlockIntegrationImpl.getCurrentMass(level, pos, copyBlockState))) < 0.001) {
            return;
        }
        Pair blockInfo = BlockStateInfo.INSTANCE.get(copyBlockState);
        if (blockInfo == null) {
            return;
        }
        shipWorld.onSetBlock(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), VSGameUtilsKt.getDimensionId((Level)level), (VsiBlockType)blockInfo.getSecond(), (VsiBlockType)blockInfo.getSecond(), oldMass, newMass);
    }

    public static void onBlockEntityDataLoaded(Level level, BlockPos pos, BlockState state, BlockState copiedBlock) {
        if (level == null || level.f_46443_) {
            return;
        }
        Block block = state.m_60734_();
        if (!(block instanceof ICopyBlock)) {
            return;
        }
        ICopyBlock copyBlock = (ICopyBlock)block;
        if (!copyBlock.useDynamicMass()) {
            return;
        }
        if (copiedBlock == null || copiedBlock.m_60795_()) {
            return;
        }
        VsiShipWorld shipWorld = VSGameUtilsKt.getShipObjectWorld((Level)level);
        if (shipWorld == null) {
            return;
        }
        double oldMass = 10.0;
        double newMass = VS2CopyBlockIntegrationImpl.getCurrentMass(level, pos, state);
        Pair blockInfo = BlockStateInfo.INSTANCE.get(state);
        if (blockInfo == null) {
            return;
        }
        shipWorld.onSetBlock(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), VSGameUtilsKt.getDimensionId((Level)level), (VsiBlockType)blockInfo.getSecond(), (VsiBlockType)blockInfo.getSecond(), oldMass, newMass);
    }

    public static void onBlockStateChanged(Level level, BlockPos pos, BlockState oldState, BlockState newState) {
        float newMultiplier;
        if (level.f_46443_) {
            return;
        }
        Block block = newState.m_60734_();
        if (!(block instanceof ICopyBlock)) {
            return;
        }
        ICopyBlock copyBlock = (ICopyBlock)block;
        if (!copyBlock.useDynamicMass()) {
            return;
        }
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof ICopyBlockEntity)) {
            return;
        }
        ICopyBlockEntity copyBE = (ICopyBlockEntity)be;
        BlockState copiedBlock = copyBE.getCopiedBlock();
        if (copiedBlock == null || copiedBlock.m_60795_()) {
            return;
        }
        float oldMultiplier = INSTANCE.getEffectiveMassMultiplier(oldState, copyBlock);
        if (Math.abs(oldMultiplier - (newMultiplier = INSTANCE.getEffectiveMassMultiplier(newState, copyBlock))) < 0.001f) {
            return;
        }
        Pair copiedInfo = BlockStateInfo.INSTANCE.get(copiedBlock);
        double baseMass = copiedInfo != null && copiedInfo.getFirst() != null ? (Double)copiedInfo.getFirst() : 50.0;
        double oldMass = baseMass * (double)oldMultiplier;
        double newMass = baseMass * (double)newMultiplier;
        VsiShipWorld shipWorld = VSGameUtilsKt.getShipObjectWorld((Level)level);
        if (shipWorld == null) {
            return;
        }
        Pair blockInfo = BlockStateInfo.INSTANCE.get(newState);
        if (blockInfo == null) {
            return;
        }
        shipWorld.onSetBlock(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), VSGameUtilsKt.getDimensionId((Level)level), (VsiBlockType)blockInfo.getSecond(), (VsiBlockType)blockInfo.getSecond(), oldMass, newMass);
    }

    public static void onBlockRemoved(Level level, BlockPos pos, BlockState state, BlockState copiedBlock) {
        if (level.f_46443_) {
            return;
        }
        Block block = state.m_60734_();
        if (!(block instanceof ICopyBlock)) {
            return;
        }
        ICopyBlock copyBlock = (ICopyBlock)block;
        if (!copyBlock.useDynamicMass()) {
            return;
        }
        VsiShipWorld shipWorld = VSGameUtilsKt.getShipObjectWorld((Level)level);
        if (shipWorld == null) {
            return;
        }
        double oldMass = VS2CopyBlockIntegrationImpl.calculateMassWithCopiedBlock(state, copiedBlock, copyBlock);
        double newMass = 10.0;
        Pair blockInfo = BlockStateInfo.INSTANCE.get(state);
        if (blockInfo == null) {
            return;
        }
        shipWorld.onSetBlock(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), VSGameUtilsKt.getDimensionId((Level)level), (VsiBlockType)blockInfo.getSecond(), (VsiBlockType)blockInfo.getSecond(), oldMass, newMass);
    }

    public static void register() {
        Registry.m_122965_((Registry)BlockStateInfo.INSTANCE.getREGISTRY(), (ResourceLocation)new ResourceLocation("imitari", "copyblock_mass"), (Object)INSTANCE);
    }

    private record Context(Level level, BlockPos pos) {
    }
}

