/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari.config;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ImitariConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.BooleanValue CONSUMES_ITEMS_IN_SURVIVAL;
    public static final ForgeConfigSpec.BooleanValue ALLOW_SURVIVAL_REMOVAL;
    public static final ForgeConfigSpec.BooleanValue ENABLE_DYNAMIC_TAGS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> TAG_BLACKLIST;
    public static final ForgeConfigSpec.BooleanValue COPY_HARDNESS;
    public static final ForgeConfigSpec.BooleanValue COPY_RESISTANCE;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "imitari.toml");
    }

    static {
        BUILDER.push("Gameplay Settings");
        CONSUMES_ITEMS_IN_SURVIVAL = BUILDER.comment("Whether placing blocks into CopyBlocks consumes items in survival mode").define("consumesItemsInSurvival", true);
        ALLOW_SURVIVAL_REMOVAL = BUILDER.comment("Whether shift+empty hand removes copied blocks in survival mode (always works in creative)").define("allowSurvivalRemoval", false);
        BUILDER.pop();
        BUILDER.push("Dynamic Systems");
        ENABLE_DYNAMIC_TAGS = BUILDER.comment("Enable dynamic tag inheritance from copied blocks").define("enableDynamicTags", true);
        TAG_BLACKLIST = BUILDER.comment(new String[]{"List of tags that CopyBlocks should NOT inherit from copied blocks", "Format: 'namespace:path' (e.g., 'minecraft:dragon_immune', 'forge:ores')", "Default blacklist includes tags that could be exploited or break game balance"}).defineList("tagBlacklist", List.of("forge:relocation_not_supported", "forge:ores"), obj -> obj instanceof String);
        COPY_HARDNESS = BUILDER.comment("Whether CopyBlocks inherit hardness (mining speed) from copied blocks").define("copyHardness", true);
        COPY_RESISTANCE = BUILDER.comment("Whether CopyBlocks inherit explosion resistance from copied blocks").define("copyResistance", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

