/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari.item;

import com.vibey.imitari.block.CopyBlockLayer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DebugToolItem
extends Item {
    public DebugToolItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(pos);
        float explosionResistance = state.getExplosionResistance((BlockGetter)context.m_43725_(), pos, null);
        float destroySpeed = state.m_60800_((BlockGetter)context.m_43725_(), pos);
        context.m_43723_().m_213846_((Component)Component.m_237113_((String)"=== Block Debug Info ==="));
        context.m_43723_().m_213846_((Component)Component.m_237113_((String)("Block: " + state.m_60734_().m_49954_().getString())));
        context.m_43723_().m_213846_((Component)Component.m_237113_((String)("Explosion Resistance: " + explosionResistance)));
        context.m_43723_().m_213846_((Component)Component.m_237113_((String)("Destroy Speed (hardness): " + destroySpeed)));
        if (state.m_61138_((Property)CopyBlockLayer.LAYERS)) {
            int layers = (Integer)state.m_61143_((Property)CopyBlockLayer.LAYERS);
            context.m_43723_().m_213846_((Component)Component.m_237113_((String)("Layers: " + layers)));
        }
        context.m_43723_().m_213846_((Component)Component.m_237113_((String)"=== Tags ==="));
        this.displayBlockTags(context, state);
        return InteractionResult.SUCCESS;
    }

    private void displayBlockTags(UseOnContext context, BlockState state) {
        List<String> tags = this.getAllBlockTags(context, state);
        if (tags.isEmpty()) {
            context.m_43723_().m_213846_((Component)Component.m_237113_((String)"No tags"));
        } else {
            context.m_43723_().m_213846_((Component)Component.m_237113_((String)("Total tags: " + tags.size())));
            this.groupAndDisplayTags(context, tags);
        }
    }

    private List<String> getAllBlockTags(UseOnContext context, BlockState state) {
        ArrayList<String> tags = new ArrayList<String>();
        try {
            Registry blockRegistry = context.m_43725_().m_9598_().m_175515_(Registries.f_256747_);
            blockRegistry.m_203613_().forEach(tagKey -> {
                if (state.m_204336_(tagKey)) {
                    tags.add(tagKey.f_203868_().toString());
                }
            });
        }
        catch (Exception e) {
            context.m_43723_().m_213846_((Component)Component.m_237113_((String)("Error getting tags: " + e.getMessage())));
        }
        tags.sort(String::compareTo);
        return tags;
    }

    private void groupAndDisplayTags(UseOnContext context, List<String> tags) {
        String currentNamespace = "";
        int tagsInNamespace = 0;
        for (String tag : tags) {
            String namespace = tag.substring(0, tag.indexOf(58));
            if (!namespace.equals(currentNamespace)) {
                if (!currentNamespace.isEmpty()) {
                    context.m_43723_().m_213846_((Component)Component.m_237113_((String)("  (" + tagsInNamespace + " tags)")));
                }
                currentNamespace = namespace;
                tagsInNamespace = 0;
                context.m_43723_().m_213846_((Component)Component.m_237113_((String)("--- " + namespace + " ---")));
            }
            String tagPath = tag.substring(tag.indexOf(58) + 1);
            context.m_43723_().m_213846_((Component)Component.m_237113_((String)("  - " + tagPath)));
            ++tagsInNamespace;
        }
        if (!currentNamespace.isEmpty()) {
            context.m_43723_().m_213846_((Component)Component.m_237113_((String)("  (" + tagsInNamespace + " tags)")));
        }
    }
}

