/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari.mixin;

import com.vibey.imitari.api.ICopyBlock;
import com.vibey.imitari.blockentity.CopyBlockEntity;
import com.vibey.imitari.config.ImitariConfig;
import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class BlockStateDestroySpeedMixin {
    @Unique
    private static volatile Boolean imitari$cachedCopyHardness = null;

    @Shadow
    public abstract Block m_60734_();

    @Inject(method={"getDestroySpeed"}, at={@At(value="HEAD")}, cancellable=true)
    private void imitari$getDynamicDestroySpeed(BlockGetter level, BlockPos pos, CallbackInfoReturnable<Float> cir) {
        Block block = this.m_60734_();
        if (!(block instanceof ICopyBlock)) {
            return;
        }
        ICopyBlock copyBlock = (ICopyBlock)block;
        if (!copyBlock.useDynamicPhysics()) {
            return;
        }
        Boolean copyHardness = imitari$cachedCopyHardness;
        if (copyHardness == null) {
            try {
                imitari$cachedCopyHardness = copyHardness = (Boolean)ImitariConfig.COPY_HARDNESS.get();
            }
            catch (Exception e) {
                copyHardness = true;
            }
        }
        if (!copyHardness.booleanValue()) {
            cir.setReturnValue((Object)Float.valueOf(0.5f));
            return;
        }
        try {
            BlockEntity be = level.m_7702_(pos);
            if (!(be instanceof CopyBlockEntity)) {
                return;
            }
            CopyBlockEntity copyBE = (CopyBlockEntity)be;
            BlockState copiedState = copyBE.getCopiedBlock();
            if (copiedState == null || copiedState.m_60795_()) {
                cir.setReturnValue((Object)Float.valueOf(0.5f));
                return;
            }
            float baseSpeed = copiedState.m_60800_(level, pos);
            if (baseSpeed < 0.0f) {
                cir.setReturnValue((Object)Float.valueOf(baseSpeed));
                return;
            }
            BlockState currentState = (BlockState)this;
            float effectiveMultiplier = this.imitari$getEffectiveMassMultiplier(currentState, copyBlock);
            float multipliedSpeed = baseSpeed * effectiveMultiplier;
            cir.setReturnValue((Object)Float.valueOf(multipliedSpeed));
        }
        catch (Exception e) {
            cir.setReturnValue((Object)Float.valueOf(0.5f));
        }
    }

    @Unique
    private float imitari$getEffectiveMassMultiplier(BlockState state, ICopyBlock copyBlock) {
        try {
            Method method = copyBlock.getClass().getMethod("getEffectiveMassMultiplier", BlockState.class);
            Object result = method.invoke((Object)copyBlock, state);
            if (result instanceof Float) {
                return ((Float)result).floatValue();
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return copyBlock.getMassMultiplier();
    }
}

