/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari.mixin;

import com.vibey.imitari.api.ICopyBlock;
import com.vibey.imitari.config.ImitariConfig;
import com.vibey.imitari.util.CopyBlockContext;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class BlockStateTagMixin {
    @Unique
    private static volatile List<? extends String> imitari$cachedBlacklist = null;

    @Shadow
    public abstract Block m_60734_();

    @Inject(method={"is(Lnet/minecraft/tags/TagKey;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void imitari$checkCopiedTags(TagKey<Block> tag, CallbackInfoReturnable<Boolean> cir) {
        Block block = this.m_60734_();
        if (!(block instanceof ICopyBlock)) {
            return;
        }
        ICopyBlock copyBlock = (ICopyBlock)block;
        if (!copyBlock.useDynamicTags()) {
            return;
        }
        if (this.imitari$isTagBlacklisted(tag)) {
            return;
        }
        Boolean result = CopyBlockContext.checkCopiedBlockTag(tag);
        if (result != null) {
            cir.setReturnValue((Object)result);
        }
    }

    @Unique
    private boolean imitari$isTagBlacklisted(TagKey<Block> tag) {
        try {
            List blacklist = imitari$cachedBlacklist;
            if (blacklist == null) {
                imitari$cachedBlacklist = blacklist = (List)ImitariConfig.TAG_BLACKLIST.get();
            }
            if (blacklist.isEmpty()) {
                return false;
            }
            ResourceLocation tagLocation = tag.f_203868_();
            String tagString = tagLocation.toString();
            for (String blacklistedTag : blacklist) {
                if (!tagString.equals(blacklistedTag)) continue;
                return true;
            }
        }
        catch (Exception e) {
            imitari$cachedBlacklist = null;
        }
        return false;
    }
}

