/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari.util;

import com.vibey.imitari.api.blockentity.ICopyBlockEntity;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CopyBlockContext {
    private static final ThreadLocal<ContextStack> CONTEXT_STACK = ThreadLocal.withInitial(ContextStack::new);
    private static final long CONTEXT_TIMEOUT_NS = 100000000L;

    public static void push(BlockGetter level, BlockPos pos) {
        CONTEXT_STACK.get().push(new Context(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
    }

    public static void pop() {
        CONTEXT_STACK.get().pop();
    }

    @Nullable
    public static Boolean checkCopiedBlockTag(TagKey<Block> tag) {
        ContextStack contextStack = CONTEXT_STACK.get();
        Context ctx = contextStack.peek();
        if (ctx == null) {
            return null;
        }
        BlockState copiedState = ctx.getCopiedBlock();
        if (copiedState == null || copiedState.m_60795_()) {
            return null;
        }
        return copiedState.m_204336_(tag);
    }

    @Nullable
    public static BlockPos getCurrentPosition() {
        Context ctx = CONTEXT_STACK.get().peek();
        if (ctx == null) {
            return null;
        }
        return new BlockPos(ctx.x, ctx.y, ctx.z);
    }

    public static boolean hasContext() {
        return CONTEXT_STACK.get().peek() != null;
    }

    public static void clearAll() {
        CONTEXT_STACK.get().clear();
    }

    private static class ContextStack {
        private final Deque<Context> stack = new ArrayDeque<Context>(4);

        private ContextStack() {
        }

        void push(Context ctx) {
            while (!this.stack.isEmpty() && this.stack.peek().isExpired()) {
                this.stack.pop();
            }
            this.stack.push(ctx);
        }

        Context peek() {
            while (!this.stack.isEmpty() && this.stack.peek().isExpired()) {
                this.stack.pop();
            }
            return this.stack.isEmpty() ? null : this.stack.peek();
        }

        void pop() {
            if (!this.stack.isEmpty()) {
                this.stack.pop();
            }
        }

        boolean isEmpty() {
            return this.stack.isEmpty();
        }

        void clear() {
            this.stack.clear();
        }
    }

    private static class Context {
        final BlockGetter level;
        final int x;
        final int y;
        final int z;
        final long timestamp;
        private BlockState cachedCopiedState;
        private boolean cacheValid;

        Context(BlockGetter level, int x, int y, int z) {
            this.level = level;
            this.x = x;
            this.y = y;
            this.z = z;
            this.timestamp = System.nanoTime();
            this.cacheValid = false;
        }

        BlockState getCopiedBlock() {
            if (this.cacheValid) {
                return this.cachedCopiedState;
            }
            try {
                BlockEntity be = this.level.m_7702_(new BlockPos(this.x, this.y, this.z));
                if (be instanceof ICopyBlockEntity) {
                    ICopyBlockEntity copyBE = (ICopyBlockEntity)be;
                    this.cachedCopiedState = copyBE.getCopiedBlock();
                    this.cacheValid = true;
                    return this.cachedCopiedState;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        boolean isExpired() {
            return System.nanoTime() - this.timestamp > 100000000L;
        }
    }
}

