/*
 * Decompiled with CFR 0.152.
 */
package com.bobotweaks.betterfurnacesandchests.client.render;

import com.bobotweaks.betterfurnacesandchests.block.CustomChestBlock;
import com.bobotweaks.betterfurnacesandchests.block.entity.CustomChestBlockEntity;
import com.bobotweaks.betterfurnacesandchests.client.render.ChestModelLoadingPlugin;
import com.bobotweaks.betterfurnacesandchests.init.ModBlocks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_827;

@Environment(value=EnvType.CLIENT)
public class CustomChestBlockEntityRenderer
implements class_827<CustomChestBlockEntity> {
    public CustomChestBlockEntityRenderer(class_5614.class_5615 context) {
    }

    public void render(CustomChestBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_761.method_23794((class_1920)entity.method_10997(), (class_2338)entity.method_11016());
        class_2680 blockState = entity.method_11010();
        if (!(blockState.method_26204() instanceof CustomChestBlock)) {
            return;
        }
        class_2350 facing = (class_2350)blockState.method_11654(CustomChestBlock.FACING);
        class_2745 chestType = (class_2745)blockState.method_11654(CustomChestBlock.CHEST_TYPE);
        int combinedLight = light;
        if (chestType != class_2745.field_12569) {
            class_2338 otherPos = entity.method_11016().method_10093(CustomChestBlock.getDirectionToOther(blockState));
            int otherLight = class_761.method_23794((class_1920)entity.method_10997(), (class_2338)otherPos);
            combinedLight = Math.max(light, otherLight);
        }
        float lidAnimationProgress = entity.method_11274(tickDelta);
        class_1092 modelManager = class_310.method_1551().method_1554();
        class_1087 baseModel = null;
        class_1087 lidModel = null;
        if (blockState.method_27852(ModBlocks.IRON_CHEST)) {
            baseModel = this.getModel(modelManager, chestType, ChestModelLoadingPlugin.IRON_CHEST_BASE, ChestModelLoadingPlugin.IRON_CHEST_LEFT_BASE, ChestModelLoadingPlugin.IRON_CHEST_RIGHT_BASE);
            lidModel = this.getModel(modelManager, chestType, ChestModelLoadingPlugin.IRON_CHEST_LID, ChestModelLoadingPlugin.IRON_CHEST_LEFT_LID, ChestModelLoadingPlugin.IRON_CHEST_RIGHT_LID);
        } else if (blockState.method_27852(ModBlocks.GOLD_CHEST)) {
            baseModel = this.getModel(modelManager, chestType, ChestModelLoadingPlugin.GOLD_CHEST_BASE, ChestModelLoadingPlugin.GOLD_CHEST_LEFT_BASE, ChestModelLoadingPlugin.GOLD_CHEST_RIGHT_BASE);
            lidModel = this.getModel(modelManager, chestType, ChestModelLoadingPlugin.GOLD_CHEST_LID, ChestModelLoadingPlugin.GOLD_CHEST_LEFT_LID, ChestModelLoadingPlugin.GOLD_CHEST_RIGHT_LID);
        } else if (blockState.method_27852(ModBlocks.DIAMOND_CHEST)) {
            baseModel = this.getModel(modelManager, chestType, ChestModelLoadingPlugin.DIAMOND_CHEST_BASE, ChestModelLoadingPlugin.DIAMOND_CHEST_LEFT_BASE, ChestModelLoadingPlugin.DIAMOND_CHEST_RIGHT_BASE);
            lidModel = this.getModel(modelManager, chestType, ChestModelLoadingPlugin.DIAMOND_CHEST_LID, ChestModelLoadingPlugin.DIAMOND_CHEST_LEFT_LID, ChestModelLoadingPlugin.DIAMOND_CHEST_RIGHT_LID);
        } else if (blockState.method_27852(ModBlocks.NETHERITE_CHEST)) {
            baseModel = this.getModel(modelManager, chestType, ChestModelLoadingPlugin.NETHERITE_CHEST_BASE, ChestModelLoadingPlugin.NETHERITE_CHEST_LEFT_BASE, ChestModelLoadingPlugin.NETHERITE_CHEST_RIGHT_BASE);
            lidModel = this.getModel(modelManager, chestType, ChestModelLoadingPlugin.NETHERITE_CHEST_LID, ChestModelLoadingPlugin.NETHERITE_CHEST_LEFT_LID, ChestModelLoadingPlugin.NETHERITE_CHEST_RIGHT_LID);
        }
        if (baseModel == null || lidModel == null) {
            return;
        }
        float rotation = 0.0f;
        switch (facing) {
            case field_11035: {
                rotation = 180.0f;
                break;
            }
            case field_11039: {
                rotation = 90.0f;
                break;
            }
            case field_11034: {
                rotation = -90.0f;
                break;
            }
            default: {
                rotation = 0.0f;
            }
        }
        matrices.method_22903();
        matrices.method_22904(0.5, 0.5, 0.5);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(rotation));
        matrices.method_22904(-0.5, -0.5, -0.5);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23581());
        class_310.method_1551().method_1541().method_3350().method_3367(matrices.method_23760(), vertexConsumer, blockState, baseModel, 1.0f, 1.0f, 1.0f, combinedLight, overlay);
        matrices.method_22903();
        matrices.method_22904(0.5, 0.625, 0.9375);
        float anim = 1.0f - (1.0f - lidAnimationProgress) * (1.0f - lidAnimationProgress) * (1.0f - lidAnimationProgress);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(anim * 90.0f));
        matrices.method_22904(-0.5, -0.625, -0.9375);
        class_310.method_1551().method_1541().method_3350().method_3367(matrices.method_23760(), vertexConsumer, blockState, lidModel, 1.0f, 1.0f, 1.0f, combinedLight, overlay);
        matrices.method_22909();
        matrices.method_22909();
    }

    private class_1087 getModel(class_1092 manager, class_2745 type, class_2960 single, class_2960 left, class_2960 right) {
        switch (type) {
            case field_12574: {
                return manager.getModel(right);
            }
            case field_12571: {
                return manager.getModel(left);
            }
        }
        return manager.getModel(single);
    }
}

