/*
 * Decompiled with CFR 0.152.
 */
package com.bobotweaks.betterfurnacesandchests.network;

import com.bobotweaks.betterfurnacesandchests.block.entity.CustomChestBlockEntity;
import com.bobotweaks.betterfurnacesandchests.mixin.DoubleInventoryAccessor;
import com.bobotweaks.betterfurnacesandchests.screen.CustomChestScreenHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class ModNetwork {
    public static final class_2960 CHEST_ACTION_ID = new class_2960("better-furnaces-and-chests", "chest_action");
    public static final class_2960 RENAME_CHEST_ID = new class_2960("better-furnaces-and-chests", "rename_chest");

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CHEST_ACTION_ID, (server, player, handler, buf, responseSender) -> {
            int actionType = buf.readInt();
            server.execute(() -> {
                class_1703 currentHandler = player.field_7512;
                if (currentHandler instanceof CustomChestScreenHandler) {
                    CustomChestScreenHandler chestHandler = (CustomChestScreenHandler)currentHandler;
                    ModNetwork.handleAction(chestHandler, actionType, player);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)RENAME_CHEST_ID, (server, player, handler, buf, responseSender) -> {
            String name = buf.method_19772();
            server.execute(() -> {
                class_1703 currentHandler = player.field_7512;
                if (currentHandler instanceof CustomChestScreenHandler) {
                    class_5250 customName;
                    CustomChestScreenHandler chestHandler = (CustomChestScreenHandler)currentHandler;
                    class_1263 inventory = chestHandler.getInventory();
                    class_5250 class_52502 = customName = name.isEmpty() ? null : class_2561.method_43470((String)name);
                    if (inventory instanceof CustomChestBlockEntity) {
                        CustomChestBlockEntity be = (CustomChestBlockEntity)inventory;
                        be.method_17488((class_2561)customName);
                        be.method_5431();
                    } else if (inventory instanceof class_1258) {
                        class_1263 patt1$temp;
                        class_1258 di = (class_1258)inventory;
                        DoubleInventoryAccessor accessor = (DoubleInventoryAccessor)di;
                        class_1263 patt0$temp = accessor.bfc$getFirst();
                        if (patt0$temp instanceof CustomChestBlockEntity) {
                            CustomChestBlockEntity be1 = (CustomChestBlockEntity)patt0$temp;
                            be1.method_17488((class_2561)customName);
                            be1.method_5431();
                        }
                        if ((patt1$temp = accessor.bfc$getSecond()) instanceof CustomChestBlockEntity) {
                            CustomChestBlockEntity be2 = (CustomChestBlockEntity)patt1$temp;
                            be2.method_17488((class_2561)customName);
                            be2.method_5431();
                        }
                    }
                }
            });
        });
    }

    private static void handleAction(CustomChestScreenHandler handler, int action, class_3222 player) {
        int totalSlots = handler.field_7761.size();
        int chestSlotCount = totalSlots - 36;
        if (chestSlotCount <= 0) {
            return;
        }
        switch (action) {
            case 0: {
                ModNetwork.sortInventory(handler, 0, chestSlotCount);
                break;
            }
            case 1: {
                ModNetwork.stackInventory(handler, 0, chestSlotCount);
                break;
            }
            case 2: {
                ModNetwork.transferToChest(handler, chestSlotCount, totalSlots, 0, chestSlotCount);
                break;
            }
            case 3: {
                ModNetwork.transferToInventory(handler, 0, chestSlotCount, chestSlotCount, totalSlots);
            }
        }
        handler.method_7623();
    }

    private static void sortInventory(CustomChestScreenHandler handler, int start, int end) {
        int i;
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (i = start; i < end; ++i) {
            class_1799 stack = ((class_1735)handler.field_7761.get(i)).method_7677();
            if (stack.method_7960()) continue;
            stacks.add(stack.method_7972());
            ((class_1735)handler.field_7761.get(i)).method_48931(class_1799.field_8037);
        }
        stacks.sort(Comparator.comparing(s -> s.method_7964().getString()).thenComparingInt(class_1799::method_7947).reversed());
        for (i = 0; i < stacks.size(); ++i) {
            if (start + i >= end) continue;
            ((class_1735)handler.field_7761.get(start + i)).method_48931((class_1799)stacks.get(i));
        }
    }

    private static void stackInventory(CustomChestScreenHandler handler, int start, int end) {
        for (int i = start; i < end; ++i) {
            class_1799 stack = ((class_1735)handler.field_7761.get(i)).method_7677();
            if (stack.method_7960() || stack.method_7947() >= stack.method_7914()) continue;
            for (int j = i + 1; j < end; ++j) {
                class_1799 other = ((class_1735)handler.field_7761.get(j)).method_7677();
                if (!class_1799.method_7984((class_1799)stack, (class_1799)other) || !Objects.equals(stack.method_7969(), other.method_7969())) continue;
                int space = stack.method_7914() - stack.method_7947();
                int toMove = Math.min(space, other.method_7947());
                stack.method_7933(toMove);
                other.method_7934(toMove);
                if (other.method_7960()) {
                    ((class_1735)handler.field_7761.get(j)).method_48931(class_1799.field_8037);
                }
                if (stack.method_7947() == stack.method_7914()) break;
            }
            ((class_1735)handler.field_7761.get(i)).method_48931(stack);
        }
    }

    private static void transferToChest(CustomChestScreenHandler handler, int srcStart, int srcEnd, int destStart, int destEnd) {
        for (int i = srcStart; i < srcEnd; ++i) {
            class_1799 stack;
            class_1735 slot = (class_1735)handler.field_7761.get(i);
            if (i >= srcEnd - 9 || (stack = slot.method_7677()).method_7960()) continue;
            class_1799 remaining = ModNetwork.insertIntoRange(handler, stack, destStart, destEnd);
            slot.method_48931(remaining);
        }
    }

    private static void transferToInventory(CustomChestScreenHandler handler, int srcStart, int srcEnd, int destStart, int destEnd) {
        for (int i = srcStart; i < srcEnd; ++i) {
            class_1735 slot = (class_1735)handler.field_7761.get(i);
            class_1799 stack = slot.method_7677();
            if (stack.method_7960()) continue;
            class_1799 remaining = ModNetwork.insertIntoRange(handler, stack, destStart, destEnd);
            slot.method_48931(remaining);
        }
    }

    private static class_1799 insertIntoRange(CustomChestScreenHandler handler, class_1799 stack, int start, int end) {
        class_1735 slot;
        int i;
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 copy = stack.method_7972();
        for (i = start; i < end; ++i) {
            int space;
            slot = (class_1735)handler.field_7761.get(i);
            class_1799 existing = slot.method_7677();
            if (!class_1799.method_7984((class_1799)copy, (class_1799)existing) || !Objects.equals(copy.method_7969(), existing.method_7969()) || (space = existing.method_7914() - existing.method_7947()) <= 0) continue;
            int move = Math.min(space, copy.method_7947());
            existing.method_7933(move);
            copy.method_7934(move);
            slot.method_48931(existing);
            if (!copy.method_7960()) continue;
            return class_1799.field_8037;
        }
        for (i = start; i < end; ++i) {
            slot = (class_1735)handler.field_7761.get(i);
            if (slot.method_7681()) continue;
            slot.method_48931(copy.method_7972());
            return class_1799.field_8037;
        }
        return copy;
    }
}

