/*
 * Decompiled with CFR 0.152.
 */
package com.bobotweaks.betterfurnacesandchests.screen;

import com.bobotweaks.betterfurnacesandchests.network.ModNetwork;
import com.bobotweaks.betterfurnacesandchests.screen.CustomChestScreenHandler;
import com.bobotweaks.betterfurnacesandchests.screen.SimpleTexturedButtonWidget;
import com.bobotweaks.betterfurnacesandchests.util.ISlot;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class CustomChestScreen
extends class_465<CustomChestScreenHandler> {
    private static final class_2960 TEXTURE = new class_2960("better-furnaces-and-chests", "textures/screens/gui.png");
    private static final class_2960 SCROLL_BG = new class_2960("better-furnaces-and-chests", "textures/screens/scroll_background.png");
    private static final class_2960 SCROLL_KNOB = new class_2960("better-furnaces-and-chests", "textures/screens/scroll_knob.png");
    private static final class_2960 SLOT_TEXTURE = new class_2960("better-furnaces-and-chests", "textures/screens/slot.png");
    private static final class_2960 SEARCH_BACKGROUND = new class_2960("better-furnaces-and-chests", "textures/screens/search-box.png");
    private static final class_2960 SEARCH_BOX_BACKGROUND = new class_2960("better-furnaces-and-chests", "textures/screens/search-background.png");
    private static final class_2960 TITLE_BACKGROUND = new class_2960("better-furnaces-and-chests", "textures/screens/title-background.png");
    private static final class_2960 SEARCH_BUTTON_TEXTURE = new class_2960("better-furnaces-and-chests", "textures/screens/search-button.png");
    private static final class_2960 SEARCH_BUTTON_HIGHLIGHTED_TEXTURE = new class_2960("better-furnaces-and-chests", "textures/screens/search-button-highlighted.png");
    private static final class_2960 CLOSE_BUTTON_TEXTURE = new class_2960("better-furnaces-and-chests", "textures/screens/close-button-search.png");
    private static final class_2960 CLOSE_BUTTON_HIGHLIGHTED_TEXTURE = new class_2960("better-furnaces-and-chests", "textures/screens/close-button-search-highlighted.png");
    private static final class_2960 SORT_BUTTON_TEXTURE = new class_2960("better-furnaces-and-chests", "textures/screens/sort-button.png");
    private static final class_2960 SORT_BUTTON_HIGHLIGHTED_TEXTURE = new class_2960("better-furnaces-and-chests", "textures/screens/sort-button-highlighted.png");
    private static final class_2960 STACK_BUTTON_TEXTURE = new class_2960("better-furnaces-and-chests", "textures/screens/stack-button.png");
    private static final class_2960 STACK_BUTTON_HIGHLIGHTED_TEXTURE = new class_2960("better-furnaces-and-chests", "textures/screens/stack-button-highlighted.png");
    private static final class_2960 TRANSFER_BUTTON_TEXTURE = new class_2960("better-furnaces-and-chests", "textures/screens/transfer-button.png");
    private static final class_2960 TRANSFER_BUTTON_HIGHLIGHTED_TEXTURE = new class_2960("better-furnaces-and-chests", "textures/screens/transfer-button-highlight.png");
    private static final class_2960 TAKE_BUTTON_TEXTURE = new class_2960("better-furnaces-and-chests", "textures/screens/take-button.png");
    private static final class_2960 TAKE_BUTTON_HIGHLIGHTED_TEXTURE = new class_2960("better-furnaces-and-chests", "textures/screens/take-button-highlight.png");
    private float scrollPosition;
    private boolean scrolling;
    private boolean showSearch = false;
    private class_4185 searchButton;
    private class_4185 closeSearchButton;
    private class_342 searchBox;
    private class_342 nameField;
    private boolean editingName = false;
    private class_2561 currentTitle;
    private int visibleRows = 0;

    public CustomChestScreen(CustomChestScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.currentTitle = title;
        this.field_2792 = 200;
        this.field_2779 = 186;
        this.field_25270 = 94;
        this.field_25269 = 20;
        this.field_25267 = 20;
        this.field_25268 = 6;
    }

    protected void method_25426() {
        super.method_25426();
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.searchButton = new SimpleTexturedButtonWidget(x - 1, y, 11, 11, SEARCH_BUTTON_TEXTURE, SEARCH_BUTTON_HIGHLIGHTED_TEXTURE, button -> this.toggleSearch(true));
        this.searchButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.better-furnaces-and-chests.search")));
        this.method_37063((class_364)this.searchButton);
        this.closeSearchButton = new SimpleTexturedButtonWidget(x - 1, y, 11, 11, CLOSE_BUTTON_TEXTURE, CLOSE_BUTTON_HIGHLIGHTED_TEXTURE, button -> this.toggleSearch(false));
        this.closeSearchButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.better-furnaces-and-chests.close_search")));
        this.method_37063((class_364)this.closeSearchButton);
        SimpleTexturedButtonWidget sortBtn = new SimpleTexturedButtonWidget(x - 1, y + 12, 11, 11, SORT_BUTTON_TEXTURE, SORT_BUTTON_HIGHLIGHTED_TEXTURE, button -> this.sendAction(0));
        sortBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.better-furnaces-and-chests.sort")));
        this.method_37063((class_364)sortBtn);
        SimpleTexturedButtonWidget stackBtn = new SimpleTexturedButtonWidget(x - 1, y + 24, 11, 11, STACK_BUTTON_TEXTURE, STACK_BUTTON_HIGHLIGHTED_TEXTURE, button -> this.sendAction(1));
        stackBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.better-furnaces-and-chests.stack")));
        this.method_37063((class_364)stackBtn);
        SimpleTexturedButtonWidget transferBtn = new SimpleTexturedButtonWidget(x - 1, y + 36, 11, 11, TRANSFER_BUTTON_TEXTURE, TRANSFER_BUTTON_HIGHLIGHTED_TEXTURE, button -> this.sendAction(2));
        transferBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.better-furnaces-and-chests.transfer")));
        this.method_37063((class_364)transferBtn);
        SimpleTexturedButtonWidget takeBtn = new SimpleTexturedButtonWidget(x - 1, y + 48, 11, 11, TAKE_BUTTON_TEXTURE, TAKE_BUTTON_HIGHLIGHTED_TEXTURE, button -> this.sendAction(3));
        takeBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.better-furnaces-and-chests.take")));
        this.method_37063((class_364)takeBtn);
        this.searchBox = new class_342(this.field_22793, x + 17, y - 8, 81, 11, class_2561.method_30163((String)""));
        this.searchBox.method_1880(50);
        this.searchBox.method_1858(false);
        this.searchBox.method_1862(false);
        this.searchBox.method_1868(-1);
        this.searchBox.method_1860(-1);
        this.searchBox.method_1863(this::onSearchChanged);
        this.method_37063((class_364)this.searchBox);
        this.nameField = new class_342(this.field_22793, x + this.field_2792 / 2 - 50, y - 22, 100, 12, class_2561.method_30163((String)""));
        this.nameField.method_1880(32);
        this.nameField.method_1858(false);
        this.nameField.method_1862(false);
        this.nameField.method_1868(-1);
        this.nameField.method_1860(-1);
        this.method_37063((class_364)this.nameField);
        this.toggleSearch(this.showSearch);
    }

    private void sendAction(int type) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(type);
        ClientPlayNetworking.send((class_2960)ModNetwork.CHEST_ACTION_ID, (class_2540)buf);
    }

    private void toggleSearch(boolean active) {
        this.showSearch = active;
        this.searchBox.method_1862(active);
        this.searchBox.method_25365(active);
        if (this.closeSearchButton != null) {
            this.closeSearchButton.field_22764 = active;
        }
        if (this.searchButton != null) {
            boolean bl = this.searchButton.field_22764 = !active;
        }
        if (!active) {
            this.searchBox.method_1852("");
        }
    }

    private void onSearchChanged(String text) {
        this.scrollPosition = 0.0f;
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        context.method_25290(TEXTURE, x + 6, y, 0.0f, 0.0f, this.field_2792, this.field_2779, this.field_2792, this.field_2779);
        if (this.showSearch) {
            context.method_25290(SEARCH_BACKGROUND, x + 12, y - 12, 0.0f, 0.0f, 90, 15, 90, 15);
            context.method_25290(SEARCH_BOX_BACKGROUND, x + 16, y - 8, 0.0f, 0.0f, 82, 11, 82, 11);
        }
        if (!this.showSearch) {
            context.method_25290(TITLE_BACKGROUND, x + this.field_2792 / 2 - 60, y - 25, 0.0f, 0.0f, 120, 18, 120, 18);
            if (!this.editingName) {
                int titleWidth = this.field_22793.method_27525((class_5348)this.currentTitle);
                context.method_27535(this.field_22793, this.currentTitle, x + this.field_2792 / 2 - titleWidth / 2, y - 20, -1);
            }
        }
        context.method_25290(SCROLL_BG, x + 187, y + 8, 0.0f, 0.0f, 8, 72, 8, 72);
        for (int i = 0; i < ((CustomChestScreenHandler)this.field_2797).field_7761.size(); ++i) {
            class_1735 slot = (class_1735)((CustomChestScreenHandler)this.field_2797).field_7761.get(i);
            if (slot.field_7873 <= -1000 || slot.field_7872 <= -1000) continue;
            context.method_25290(SLOT_TEXTURE, this.field_2776 + slot.field_7873 - 1, this.field_2800 + slot.field_7872 - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        }
        int knobY = (int)(63.0f * this.scrollPosition);
        context.method_25290(SCROLL_KNOB, x + 188, y + 9 + knobY, 0.0f, 0.0f, 6, 7, 6, 7);
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.calculateVisibleRows();
        this.updateSlots();
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
    }

    private void calculateVisibleRows() {
        if (!this.showSearch || this.searchBox.method_1882().isEmpty()) {
            this.visibleRows = ((CustomChestScreenHandler)this.field_2797).getRows();
            return;
        }
        int matches = 0;
        String query = this.searchBox.method_1882().toLowerCase();
        int chestSize = ((CustomChestScreenHandler)this.field_2797).field_7761.size() - 36;
        for (int i = 0; i < chestSize; ++i) {
            class_1799 stack = ((class_1735)((CustomChestScreenHandler)this.field_2797).field_7761.get(i)).method_7677();
            if (stack.method_7960() || !stack.method_7964().getString().toLowerCase().contains(query)) continue;
            ++matches;
        }
        this.visibleRows = (int)Math.ceil((double)matches / 9.0);
    }

    private void updateSlots() {
        int rowOffset = this.getRowOffset();
        String query = this.showSearch && !this.searchBox.method_1882().isEmpty() ? this.searchBox.method_1882().toLowerCase() : null;
        int visualIndex = 0;
        int chestSize = ((CustomChestScreenHandler)this.field_2797).field_7761.size() - 36;
        for (int i = 0; i < ((CustomChestScreenHandler)this.field_2797).field_7761.size(); ++i) {
            class_1735 slot = (class_1735)((CustomChestScreenHandler)this.field_2797).field_7761.get(i);
            if (i >= chestSize) continue;
            boolean visible = true;
            if (query != null && (slot.method_7677().method_7960() || !slot.method_7677().method_7964().getString().toLowerCase().contains(query))) {
                visible = false;
            }
            if (visible) {
                int row = visualIndex / 9;
                int col = visualIndex % 9;
                int slotY = 9 + (row - rowOffset) * 18;
                ((ISlot)slot).bfc$setX(19 + col * 18);
                if (slotY >= 9 && slotY < 81) {
                    ((ISlot)slot).bfc$setY(slotY);
                } else {
                    ((ISlot)slot).bfc$setY(-10000);
                }
                ++visualIndex;
                continue;
            }
            ((ISlot)slot).bfc$setX(-10000);
            ((ISlot)slot).bfc$setY(-10000);
        }
    }

    private int getRowOffset() {
        int scrollableRows = this.visibleRows - 4;
        return Math.max(0, (int)(this.scrollPosition * (float)scrollableRows + 0.5f));
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.showSearch) {
            if (keyCode == 256) {
                this.toggleSearch(false);
                return true;
            }
            if (this.searchBox.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
        }
        if (this.editingName) {
            if (keyCode == 257 || keyCode == 335) {
                this.setEditingName(false, true);
                return true;
            }
            if (keyCode == 256) {
                this.setEditingName(false, false);
                return true;
            }
            if (this.nameField.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void setEditingName(boolean editing, boolean save) {
        this.editingName = editing;
        this.nameField.method_1862(editing);
        this.nameField.method_25365(editing);
        if (editing) {
            this.nameField.method_1852(this.currentTitle.getString());
        } else if (save) {
            String newName = this.nameField.method_1882();
            this.currentTitle = newName.isEmpty() ? ((CustomChestScreenHandler)this.field_2797).getDisplayName() : class_2561.method_43470((String)newName);
            class_2540 buf = PacketByteBufs.create();
            buf.method_10814(newName);
            ClientPlayNetworking.send((class_2960)ModNetwork.RENAME_CHEST_ID, (class_2540)buf);
        }
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.showSearch && this.searchBox.method_25400(chr, modifiers)) {
            return true;
        }
        if (this.editingName && this.nameField.method_25400(chr, modifiers)) {
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        int scrollableRows = this.visibleRows - 4;
        if (scrollableRows > 0) {
            float f = 1.0f / (float)scrollableRows;
            this.scrollPosition = class_3532.method_15363((float)(this.scrollPosition - (float)amount * f), (float)0.0f, (float)1.0f);
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling) {
            int y = this.field_2800 + 9;
            int h = y + 72;
            int scrollableRows = this.visibleRows - 4;
            if (scrollableRows > 0) {
                this.scrollPosition = class_3532.method_15363((float)(((float)mouseY - (float)y - 3.5f) / ((float)(h - y) - 7.0f)), (float)0.0f, (float)1.0f);
                return true;
            }
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int x = this.field_2776 + 187;
            int y = this.field_2800 + 8;
            if (mouseX >= (double)x && mouseX < (double)(x + 8) && mouseY >= (double)y && mouseY < (double)(y + 72)) {
                this.scrolling = true;
                return true;
            }
        }
        if (this.showSearch && this.searchBox.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        int tx = this.field_2776 + this.field_2792 / 2 - 60;
        int ty = this.field_2800 - 25;
        if (mouseX >= (double)tx && mouseX < (double)(tx + 120) && mouseY >= (double)ty && mouseY < (double)(ty + 18)) {
            this.setEditingName(true, false);
            return true;
        }
        if (this.editingName) {
            this.setEditingName(false, true);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrolling = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    protected boolean method_2378(int x, int y, int width, int height, double pointX, double pointY) {
        double relY = pointY - (double)this.field_2800;
        if (width == 16 && height == 16 && (relY < 8.0 || relY >= 80.0 && relY < 106.0 || relY >= 182.0)) {
            return false;
        }
        return super.method_2378(x, y, width, height, pointX, pointY);
    }
}

