/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.mobdismemberment.client.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.ichun.mods.mobdismemberment.client.entity.EntityGib;
import me.ichun.mods.mobdismemberment.client.helper.ModelHelper;
import me.ichun.mods.mobdismemberment.common.MobDismemberment;
import me.ichun.mods.mobdismemberment.common.core.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandlerClient {
    public HashMap<LivingEntity, Integer> dismemberTimeout = new HashMap();
    public HashMap<Entity, Integer> exploTime = new HashMap();
    public ArrayList<Entity> explosionSources = new ArrayList();
    public ArrayList<EntityGib> activeGibs = new ArrayList();

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().f_46443_ && !(entity instanceof Player) && !entity.m_6162_()) {
            this.dismemberTimeout.put(entity, 2);
        }
    }

    @SubscribeEvent
    public void onClientConnection(ClientPlayerNetworkEvent.LoggingIn event) {
        this.exploTime.clear();
        this.dismemberTimeout.clear();
        this.explosionSources.clear();
        this.activeGibs.clear();
    }

    @SubscribeEvent
    public void worldTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91073_ != null) {
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel world = mc.f_91073_;
            ++MobDismemberment.clientTicks;
            if (!mc.m_91104_()) {
                this.activeGibs.removeIf(Entity::m_213877_);
                for (Entity ent : world.m_104735_()) {
                    if ((ent instanceof Creeper || ent instanceof PrimedTnt || ent instanceof MinecartTNT) && !this.explosionSources.contains(ent)) {
                        this.explosionSources.add(ent);
                    }
                    if (!(ent instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)ent;
                    if (ent instanceof Player || living.m_6162_() || ent.m_6084_() || this.dismemberTimeout.containsKey(ent)) continue;
                    this.dismemberTimeout.put(living, 2);
                }
                for (int i = this.explosionSources.size() - 1; i >= 0; --i) {
                    Entity ent;
                    ent = this.explosionSources.get(i);
                    if (!ent.m_213877_()) continue;
                    if (ent instanceof Creeper) {
                        Creeper creeper = (Creeper)ent;
                        float swellProgress = creeper.m_32320_(0.0f);
                        if (swellProgress >= 0.95f) {
                            if (!this.exploTime.containsKey(ent)) {
                                int time = MobDismemberment.clientTicks % 24000;
                                if (time > 23959) {
                                    time -= 23999;
                                }
                                this.exploTime.put(ent, time);
                            }
                            this.dismemberTimeout.put((LivingEntity)creeper, 2);
                        }
                    } else if ((ent instanceof PrimedTnt || ent instanceof MinecartTNT) && !this.exploTime.containsKey(ent)) {
                        int time = MobDismemberment.clientTicks % 24000;
                        if (time > 23959) {
                            time -= 23999;
                        }
                        this.exploTime.put(ent, time);
                    }
                    this.explosionSources.remove(i);
                }
                Iterator<Map.Entry<LivingEntity, Integer>> ite = this.dismemberTimeout.entrySet().iterator();
                if (ite.hasNext()) {
                    Map.Entry<LivingEntity, Integer> e = ite.next();
                    e.setValue(e.getValue() - 1);
                    e.getKey().f_20916_ = 0;
                    e.getKey().f_20919_ = 0;
                    Entity explo = null;
                    double dist = 1000.0;
                    for (Map.Entry<Entity, Integer> e1 : this.exploTime.entrySet()) {
                        double mobDist = e1.getKey().m_20270_((Entity)e.getKey());
                        if (!(mobDist < 10.0) || !(mobDist < dist)) continue;
                        dist = mobDist;
                        explo = e1.getKey();
                        e.setValue(0);
                    }
                    if (e.getValue() <= 0) {
                        if (this.dismember((ClientLevel)e.getKey().m_9236_(), e.getKey(), explo)) {
                            e.getKey().m_146870_();
                        }
                        ite.remove();
                    }
                }
                Iterator<Map.Entry<Entity, Integer>> ite1 = this.exploTime.entrySet().iterator();
                int worldTime = MobDismemberment.clientTicks % 24000;
                while (ite1.hasNext()) {
                    Map.Entry<Entity, Integer> e = ite1.next();
                    if (e.getValue() + 40 >= worldTime) continue;
                    ite1.remove();
                }
            }
        }
    }

    public boolean dismember(ClientLevel world, LivingEntity living, Entity explo) {
        if (living.m_6162_()) {
            return false;
        }
        List<ModelHelper.PartData> parts = ModelHelper.extractModelParts(living);
        if (parts.isEmpty()) {
            return false;
        }
        for (ModelHelper.PartData partData : parts) {
            this.addClientEntity(world, new EntityGib((Level)world, living, partData, explo));
        }
        if (((Boolean)Config.BLOOD.get()).booleanValue()) {
            for (int k = 0; k < (explo != null ? (Integer)Config.BLOOD_COUNT.get() * 10 : (Integer)Config.BLOOD_COUNT.get()); ++k) {
                float var4 = 0.3f;
                double mX = -Mth.m_14031_((float)(living.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(living.m_146909_() / 180.0f * (float)Math.PI)) * var4;
                double mZ = Mth.m_14089_((float)(living.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(living.m_146909_() / 180.0f * (float)Math.PI)) * var4;
                double mY = -Mth.m_14031_((float)(living.m_146909_() / 180.0f * (float)Math.PI)) * var4 + 0.1f;
                var4 = 0.02f;
                float var5 = living.m_217043_().m_188501_() * (float)Math.PI * 2.0f;
                var4 *= living.m_217043_().m_188501_();
                if (explo != null) {
                    var4 = (float)((double)var4 * 100.0);
                }
                world.m_7106_((ParticleOptions)MobDismemberment.BLOOD_PARTICLE.get(), living.m_20185_(), living.m_20186_() + 0.5 + living.m_217043_().m_188500_() * 0.7, living.m_20189_(), living.m_20184_().f_82479_ + (mX += Math.cos(var5) * (double)var4), living.m_20184_().f_82480_ + (mY += (double)((living.m_217043_().m_188501_() - living.m_217043_().m_188501_()) * 0.1f)), living.m_20184_().f_82481_ + (mZ += Math.sin(var5) * (double)var4));
            }
        }
        return true;
    }

    private void addClientEntity(ClientLevel world, EntityGib entity) {
        world.m_104627_(entity.m_19879_(), (Entity)entity);
        this.activeGibs.add(entity);
    }
}

