/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.mobdismemberment.client.helper;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ModelHelper {
    public static List<PartData> extractModelParts(LivingEntity entity) {
        ArrayList<PartData> parts = new ArrayList<PartData>();
        HashSet<ModelPart> processedParts = new HashSet<ModelPart>();
        try {
            LivingEntityRenderer livingRenderer;
            EntityModel model;
            EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)entity);
            if (renderer instanceof LivingEntityRenderer && (model = (livingRenderer = (LivingEntityRenderer)renderer).m_7200_()) != null) {
                List<ModelPart> allParts = ModelHelper.findAllModelParts(model);
                for (ModelPart part : allParts) {
                    ModelHelper.extractPartsRecursive(part, "", parts, 0.0f, 0.0f, 0.0f, processedParts);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parts;
    }

    public static ResourceLocation getEntityTexture(LivingEntity entity) {
        try {
            EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)entity);
            if (renderer instanceof LivingEntityRenderer) {
                LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
                return livingRenderer.m_5478_((Entity)entity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ResourceLocation("textures/entity/zombie/zombie.png");
    }

    private static List<ModelPart> findAllModelParts(EntityModel<?> model) {
        ArrayList<ModelPart> modelParts = new ArrayList<ModelPart>();
        HashSet<ModelPart> seen = new HashSet<ModelPart>();
        for (Class<?> clazz = model.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                try {
                    ModelPart part;
                    field.setAccessible(true);
                    Object value = field.get(model);
                    if (!(value instanceof ModelPart) || seen.contains(part = (ModelPart)value)) continue;
                    modelParts.add(part);
                    seen.add(part);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return modelParts;
    }

    private static void extractPartsRecursive(ModelPart part, String name, List<PartData> parts, float parentX, float parentY, float parentZ, Set<ModelPart> processedParts) {
        if (processedParts.contains(part)) {
            return;
        }
        processedParts.add(part);
        float worldX = parentX + part.f_104200_ / 16.0f;
        float worldY = parentY + part.f_104201_ / 16.0f;
        float worldZ = parentZ + part.f_104202_ / 16.0f;
        if (ModelHelper.hasCubes(part)) {
            parts.add(new PartData(part, name, worldX, worldY, worldZ));
        }
        try {
            Map<String, ModelPart> children = ModelHelper.getChildren(part);
            if (children != null) {
                for (Map.Entry<String, ModelPart> entry : children.entrySet()) {
                    String childName = name.isEmpty() ? entry.getKey() : name + "." + entry.getKey();
                    ModelHelper.extractPartsRecursive(entry.getValue(), childName, parts, worldX, worldY, worldZ, processedParts);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean hasCubes(ModelPart part) {
        try {
            for (Field field : ModelPart.class.getDeclaredFields()) {
                Object first;
                if (field.getType() != List.class) continue;
                field.setAccessible(true);
                List list = (List)field.get(part);
                if (list == null || list.isEmpty() || !(first = list.get(0)).getClass().getName().contains("Cube")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static Map<String, ModelPart> getChildren(ModelPart part) {
        try {
            for (Field field : ModelPart.class.getDeclaredFields()) {
                if (field.getType() != Map.class) continue;
                field.setAccessible(true);
                return (Map)field.get(part);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static float[] calculateGeometricCenter(ModelPart part) {
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float minZ = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        float maxZ = Float.MIN_VALUE;
        boolean foundCubes = false;
        try {
            List cubes = null;
            for (Field field : ModelPart.class.getDeclaredFields()) {
                Object first;
                if (field.getType() != List.class) continue;
                field.setAccessible(true);
                List list = (List)field.get(part);
                if (list == null || list.isEmpty() || !(first = list.get(0)).getClass().getName().contains("Cube")) continue;
                cubes = list;
                break;
            }
            if (cubes != null) {
                Field minXField = null;
                Field minYField = null;
                Field minZField = null;
                Field maxXField = null;
                Field maxYField = null;
                Field maxZField = null;
                Class<?> cubeClass = cubes.get(0).getClass();
                for (Field field : cubeClass.getDeclaredFields()) {
                    field.setAccessible(true);
                    String name = field.getName();
                    if (name.equals("minX") || name.contains("minX")) {
                        minXField = field;
                        continue;
                    }
                    if (name.equals("minY") || name.contains("minY")) {
                        minYField = field;
                        continue;
                    }
                    if (name.equals("minZ") || name.contains("minZ")) {
                        minZField = field;
                        continue;
                    }
                    if (name.equals("maxX") || name.contains("maxX")) {
                        maxXField = field;
                        continue;
                    }
                    if (name.equals("maxY") || name.contains("maxY")) {
                        maxYField = field;
                        continue;
                    }
                    if (!name.equals("maxZ") && !name.contains("maxZ")) continue;
                    maxZField = field;
                }
                if (minXField == null) {
                    ArrayList<Field> floatFields = new ArrayList<Field>();
                    for (Field field : cubeClass.getDeclaredFields()) {
                        if (field.getType() != Float.TYPE) continue;
                        field.setAccessible(true);
                        floatFields.add(field);
                    }
                    if (floatFields.size() >= 6) {
                        minXField = (Field)floatFields.get(0);
                        minYField = (Field)floatFields.get(1);
                        minZField = (Field)floatFields.get(2);
                        maxXField = (Field)floatFields.get(3);
                        maxYField = (Field)floatFields.get(4);
                        maxZField = (Field)floatFields.get(5);
                    }
                }
                if (minXField != null && maxXField != null) {
                    for (Object cube : cubes) {
                        float cubeMinX = minXField.getFloat(cube);
                        float cubeMinY = minYField.getFloat(cube);
                        float cubeMinZ = minZField.getFloat(cube);
                        float cubeMaxX = maxXField.getFloat(cube);
                        float cubeMaxY = maxYField.getFloat(cube);
                        float cubeMaxZ = maxZField.getFloat(cube);
                        minX = Math.min(minX, cubeMinX);
                        minY = Math.min(minY, cubeMinY);
                        minZ = Math.min(minZ, cubeMinZ);
                        maxX = Math.max(maxX, cubeMaxX);
                        maxY = Math.max(maxY, cubeMaxY);
                        maxZ = Math.max(maxZ, cubeMaxZ);
                        foundCubes = true;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (foundCubes) {
            return new float[]{(minX + maxX) / 2.0f, (minY + maxY) / 2.0f, (minZ + maxZ) / 2.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    public static class PartData {
        public final ModelPart part;
        public final String name;
        public final float offsetX;
        public final float offsetY;
        public final float offsetZ;
        public final float centerX;
        public final float centerY;
        public final float centerZ;

        public PartData(ModelPart part, String name, float offsetX, float offsetY, float offsetZ) {
            this.part = part;
            this.name = name;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            float[] center = ModelHelper.calculateGeometricCenter(part);
            this.centerX = center[0];
            this.centerY = center[1];
            this.centerZ = center[2];
        }
    }
}

