/*
 * Decompiled with CFR 0.152.
 */
package jackperry2187.effigies;

import jackperry2187.effigies.PikeTier;
import jackperry2187.effigies.block.PikeBlock;
import jackperry2187.effigies.block.entity.PikeBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public final class PikeRegistry {
    private static final Map<ResourceKey<Level>, Map<Long, List<PikeData>>> pikesByDimension = new ConcurrentHashMap<ResourceKey<Level>, Map<Long, List<PikeData>>>();
    private static int maxChunkRadius = -1;

    private PikeRegistry() {
    }

    private static int getMaxChunkRadius() {
        if (maxChunkRadius < 0) {
            maxChunkRadius = 0;
            for (PikeTier tier : PikeTier.values()) {
                maxChunkRadius = Math.max(maxChunkRadius, tier.chunkRadius());
            }
        }
        return maxChunkRadius;
    }

    private static long chunkKey(int chunkX, int chunkZ) {
        return ChunkPos.asLong((int)chunkX, (int)chunkZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPike(ServerLevel level, BlockPos pos, PikeTier tier, EntityType<?> entityType) {
        List chunkPikes;
        ResourceKey dimension = level.dimension();
        Map dimensionPikes = pikesByDimension.computeIfAbsent((ResourceKey<Level>)dimension, k -> new ConcurrentHashMap());
        int chunkX = pos.getX() >> 4;
        int chunkZ = pos.getZ() >> 4;
        long chunkKey = PikeRegistry.chunkKey(chunkX, chunkZ);
        List list = chunkPikes = dimensionPikes.computeIfAbsent(chunkKey, k -> new ArrayList());
        synchronized (list) {
            for (PikeData existing : chunkPikes) {
                if (!existing.pos().equals((Object)pos)) continue;
                return;
            }
            chunkPikes.add(new PikeData(pos, tier, entityType, chunkX, chunkZ));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterPike(ServerLevel level, BlockPos pos) {
        int chunkZ;
        ResourceKey dimension = level.dimension();
        Map<Long, List<PikeData>> dimensionPikes = pikesByDimension.get(dimension);
        if (dimensionPikes == null) {
            return;
        }
        int chunkX = pos.getX() >> 4;
        long chunkKey = PikeRegistry.chunkKey(chunkX, chunkZ = pos.getZ() >> 4);
        List<PikeData> chunkPikes = dimensionPikes.get(chunkKey);
        if (chunkPikes == null) {
            return;
        }
        List<PikeData> list = chunkPikes;
        synchronized (list) {
            chunkPikes.removeIf(pike -> pike.pos().equals((Object)pos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePikeEntityType(ServerLevel level, BlockPos pos, EntityType<?> newEntityType) {
        int chunkZ;
        ResourceKey dimension = level.dimension();
        Map<Long, List<PikeData>> dimensionPikes = pikesByDimension.get(dimension);
        if (dimensionPikes == null) {
            return;
        }
        int chunkX = pos.getX() >> 4;
        long chunkKey = PikeRegistry.chunkKey(chunkX, chunkZ = pos.getZ() >> 4);
        List<PikeData> chunkPikes = dimensionPikes.get(chunkKey);
        if (chunkPikes == null) {
            return;
        }
        List<PikeData> list = chunkPikes;
        synchronized (list) {
            for (int i = 0; i < chunkPikes.size(); ++i) {
                PikeData pike = chunkPikes.get(i);
                if (!pike.pos().equals((Object)pos)) continue;
                chunkPikes.set(i, new PikeData(pos, pike.tier(), newEntityType, chunkX, chunkZ));
                return;
            }
        }
    }

    public static void onChunkUnload(ServerLevel level, int chunkX, int chunkZ) {
        ResourceKey dimension = level.dimension();
        Map<Long, List<PikeData>> dimensionPikes = pikesByDimension.get(dimension);
        if (dimensionPikes == null) {
            return;
        }
        long chunkKey = PikeRegistry.chunkKey(chunkX, chunkZ);
        dimensionPikes.remove(chunkKey);
    }

    public static void onChunkLoad(ServerLevel level, LevelChunk chunk) {
        for (BlockEntity blockEntity : chunk.getBlockEntities().values()) {
            BlockState headState;
            EntityType<?> entityType;
            BlockPos pos;
            BlockState state;
            Block block;
            if (!(blockEntity instanceof PikeBlockEntity) || !((block = (state = chunk.getBlockState(pos = blockEntity.getBlockPos())).getBlock()) instanceof PikeBlock)) continue;
            PikeBlock pikeBlock = (PikeBlock)block;
            if (!((Boolean)state.getValue((Property)PikeBlock.ACTIVATED)).booleanValue() || (entityType = PikeBlockEntity.getHeadTypeFromBlockState(headState = chunk.getBlockState(pos.above()))) == null) continue;
            PikeRegistry.registerPike(level, pos, pikeBlock.tier(), entityType);
        }
    }

    public static void onWorldUnload(ResourceKey<Level> dimension) {
        pikesByDimension.remove(dimension);
    }

    public static void clearAll() {
        pikesByDimension.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static PikeData getBlockingPike(ServerLevel level, BlockPos spawnPos, EntityType<?> entityType) {
        ResourceKey dimension = level.dimension();
        Map<Long, List<PikeData>> dimensionPikes = pikesByDimension.get(dimension);
        if (dimensionPikes == null || dimensionPikes.isEmpty()) {
            return null;
        }
        int spawnChunkX = spawnPos.getX() >> 4;
        int spawnChunkZ = spawnPos.getZ() >> 4;
        int maxRadius = PikeRegistry.getMaxChunkRadius();
        for (int dx = -maxRadius; dx <= maxRadius; ++dx) {
            for (int dz = -maxRadius; dz <= maxRadius; ++dz) {
                long chunkKey = PikeRegistry.chunkKey(spawnChunkX + dx, spawnChunkZ + dz);
                List<PikeData> chunkPikes = dimensionPikes.get(chunkKey);
                if (chunkPikes == null || chunkPikes.isEmpty()) continue;
                List<PikeData> list = chunkPikes;
                synchronized (list) {
                    for (PikeData pike : chunkPikes) {
                        int chunkDistance;
                        if (pike.entityType() != entityType || (chunkDistance = Math.max(Math.abs(pike.chunkX() - spawnChunkX), Math.abs(pike.chunkZ() - spawnChunkZ))) > pike.tier().chunkRadius()) continue;
                        return pike;
                    }
                    continue;
                }
            }
        }
        return null;
    }

    public record PikeData(BlockPos pos, PikeTier tier, EntityType<?> entityType, int chunkX, int chunkZ) {
    }
}

