/*
 * Decompiled with CFR 0.152.
 */
package jackperry2187.effigies;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public enum PikeTier {
    WOODEN(0, SoundType.WOOD, 1.0f, 1.0f),
    STONE(1, SoundType.STONE, 1.5f, 6.0f),
    COPPER(2, SoundType.COPPER, 3.0f, 6.0f),
    IRON(4, SoundType.METAL, 5.0f, 6.0f),
    GOLDEN(6, SoundType.METAL, 3.0f, 6.0f),
    DIAMOND(8, SoundType.METAL, 5.0f, 6.0f),
    NETHERITE(16, SoundType.NETHERITE_BLOCK, 50.0f, 1200.0f);

    private final int chunkRadius;
    private final SoundType soundType;
    private final float hardness;
    private final float resistance;

    private PikeTier(int chunkRadius, SoundType soundType, float hardness, float resistance) {
        this.chunkRadius = chunkRadius;
        this.soundType = soundType;
        this.hardness = hardness;
        this.resistance = resistance;
    }

    public int chunkRadius() {
        return this.chunkRadius;
    }

    public BlockBehaviour.Properties blockProperties(String modId, String blockName) {
        return BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (Identifier)Identifier.fromNamespaceAndPath((String)modId, (String)blockName))).strength(this.hardness, this.resistance).sound(this.soundType).noOcclusion();
    }
}

