/*
 * Decompiled with CFR 0.152.
 */
package jackperry2187.effigies.block;

import jackperry2187.effigies.PikeRegistry;
import jackperry2187.effigies.PikeTier;
import jackperry2187.effigies.block.entity.PikeBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PikeBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty ACTIVATED = BooleanProperty.create((String)"activated");
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private final PikeTier tier;

    public PikeBlock(PikeTier tier, BlockBehaviour.Properties props) {
        super(props);
        this.tier = tier;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    public PikeTier tier() {
        return this.tier;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        BlockPos headPos = pos.above();
        BlockState headState = level.getBlockState(headPos);
        if (!PikeBlockEntity.isValidHeadBlock(headState)) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)), 3);
            level.destroyBlock(headPos, true);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, 15, 0.3, 0.4, 0.3, 0.02);
            }
        }
        return level.isClientSide() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.isShiftKeyDown()) {
            BlockPos headPos = pos.above();
            BlockState headState = level.getBlockState(headPos);
            if (PikeBlockEntity.isValidHeadBlock(headState)) {
                if (!level.isClientSide()) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)), 3);
                    level.destroyBlock(headPos, true);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, 15, 0.3, 0.4, 0.3, 0.02);
                    }
                }
                return level.isClientSide() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        EntityType<?> headType = PikeBlockEntity.getHeadTypeFromItem(stack);
        if (headType == null) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        BlockPos headPos = pos.above();
        if (PikeBlockEntity.isValidHeadBlock(level.getBlockState(headPos)) || !this.canPlaceHead(level, headPos)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        BlockState headState = PikeBlockEntity.getHeadBlockStateForItem(stack);
        if (headState == null) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (!level.isClientSide()) {
            int rotation = Mth.floor((double)((double)(player.getYRot() * 16.0f / 360.0f) + 0.5)) & 0xF;
            headState = (BlockState)headState.setValue((Property)SkullBlock.ROTATION, (Comparable)Integer.valueOf(rotation));
            level.setBlock(headPos, headState, 3);
            level.setBlock(pos, (BlockState)state.setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(true)), 3);
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
        }
        return level.isClientSide() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide()) {
            if (((Boolean)state.getValue((Property)ACTIVATED)).booleanValue() && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                PikeRegistry.unregisterPike(serverLevel, pos);
            }
            this.breakHeadAbove(level, pos);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (((Boolean)state.getValue((Property)ACTIVATED)).booleanValue()) {
                PikeRegistry.unregisterPike(serverLevel, pos);
            }
            this.breakHeadAbove((Level)serverLevel, pos);
        }
        super.destroy(level, pos, state);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide()) {
            this.updateActivatedState(level, pos, state);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, @Nullable Orientation orientation, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, orientation, isMoving);
        if (!level.isClientSide()) {
            this.updateActivatedState(level, pos, state);
        }
    }

    protected BlockState updateShape(BlockState state, LevelReader levelReader, ScheduledTickAccess tickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        return super.updateShape(state, levelReader, tickAccess, pos, direction, neighborPos, neighborState, random);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVATED});
    }

    @Nullable
    public PikeBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PikeBlockEntity(pos, state);
    }

    private void updateActivatedState(Level level, BlockPos pos, BlockState state) {
        BlockState headState = level.getBlockState(pos.above());
        boolean active = PikeBlockEntity.isValidHeadBlock(headState);
        BlockState currentWorldState = level.getBlockState(pos);
        boolean wasActive = (Boolean)currentWorldState.getValue((Property)ACTIVATED);
        if (wasActive != active) {
            level.setBlock(pos, (BlockState)currentWorldState.setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(active)), 3);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (active) {
                    EntityType<?> headType = PikeBlockEntity.getHeadTypeFromBlockState(headState);
                    if (headType != null) {
                        PikeRegistry.registerPike(serverLevel, pos, this.tier, headType);
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, 15, 0.3, 0.4, 0.3, 0.02);
                    }
                } else {
                    PikeRegistry.unregisterPike(serverLevel, pos);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, 15, 0.3, 0.4, 0.3, 0.02);
                }
            }
        }
    }

    private void breakHeadAbove(Level level, BlockPos pos) {
        BlockPos headPos = pos.above();
        BlockState headState = level.getBlockState(headPos);
        if (PikeBlockEntity.isValidHeadBlock(headState)) {
            level.destroyBlock(headPos, true);
        }
    }

    private boolean canPlaceHead(Level level, BlockPos headPos) {
        BlockState state = level.getBlockState(headPos);
        return state.isAir() || state.getBlock() == Blocks.WATER || state.getBlock() == Blocks.LAVA;
    }
}

