/*
 * Decompiled with CFR 0.152.
 */
package jackperry2187.effigies.block.entity;

import jackperry2187.effigies.registry.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PikeBlockEntity
extends BlockEntity {
    public PikeBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.pike(), pos, state);
    }

    public static boolean isValidHeadItem(ItemStack stack) {
        return PikeBlockEntity.getHeadTypeFromItem(stack) != null;
    }

    public static boolean isValidHeadBlock(BlockState state) {
        return PikeBlockEntity.getHeadTypeFromBlockState(state) != null;
    }

    @Nullable
    public static BlockState getHeadBlockStateForItem(ItemStack stack) {
        if (stack.is(Items.SKELETON_SKULL)) {
            return Blocks.SKELETON_SKULL.defaultBlockState();
        }
        if (stack.is(Items.WITHER_SKELETON_SKULL)) {
            return Blocks.WITHER_SKELETON_SKULL.defaultBlockState();
        }
        if (stack.is(Items.ZOMBIE_HEAD)) {
            return Blocks.ZOMBIE_HEAD.defaultBlockState();
        }
        if (stack.is(Items.CREEPER_HEAD)) {
            return Blocks.CREEPER_HEAD.defaultBlockState();
        }
        if (stack.is(Items.PIGLIN_HEAD)) {
            return Blocks.PIGLIN_HEAD.defaultBlockState();
        }
        return null;
    }

    @Nullable
    public static EntityType<?> getHeadTypeFromItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        if (stack.is(Items.SKELETON_SKULL)) {
            return EntityType.SKELETON;
        }
        if (stack.is(Items.WITHER_SKELETON_SKULL)) {
            return EntityType.WITHER_SKELETON;
        }
        if (stack.is(Items.ZOMBIE_HEAD)) {
            return EntityType.ZOMBIE;
        }
        if (stack.is(Items.CREEPER_HEAD)) {
            return EntityType.CREEPER;
        }
        if (stack.is(Items.PIGLIN_HEAD)) {
            return EntityType.PIGLIN;
        }
        return null;
    }

    @Nullable
    public static EntityType<?> getHeadTypeFromBlockState(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof SkullBlock) {
            SkullBlock skullBlock = (SkullBlock)block;
            SkullBlock.Type type = skullBlock.getType();
            return PikeBlockEntity.getHeadTypeFromSkullType(type);
        }
        return null;
    }

    @Nullable
    private static EntityType<?> getHeadTypeFromSkullType(SkullBlock.Type type) {
        if (type == SkullBlock.Types.SKELETON) {
            return EntityType.SKELETON;
        }
        if (type == SkullBlock.Types.WITHER_SKELETON) {
            return EntityType.WITHER_SKELETON;
        }
        if (type == SkullBlock.Types.ZOMBIE) {
            return EntityType.ZOMBIE;
        }
        if (type == SkullBlock.Types.CREEPER) {
            return EntityType.CREEPER;
        }
        if (type == SkullBlock.Types.PIGLIN) {
            return EntityType.PIGLIN;
        }
        return null;
    }
}

