/*
 * Decompiled with CFR 0.152.
 */
package jackperry2187.effigies;

import jackperry2187.effigies.PikeTier;
import jackperry2187.effigies.block.PikeBlock;
import jackperry2187.effigies.block.entity.PikeBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public final class PikeRegistry {
    private static final Map<class_5321<class_1937>, Map<Long, List<PikeData>>> pikesByDimension = new ConcurrentHashMap<class_5321<class_1937>, Map<Long, List<PikeData>>>();
    private static int maxChunkRadius = -1;

    private PikeRegistry() {
    }

    private static int getMaxChunkRadius() {
        if (maxChunkRadius < 0) {
            maxChunkRadius = 0;
            for (PikeTier tier : PikeTier.values()) {
                maxChunkRadius = Math.max(maxChunkRadius, tier.chunkRadius());
            }
        }
        return maxChunkRadius;
    }

    private static long chunkKey(int chunkX, int chunkZ) {
        return class_1923.method_8331((int)chunkX, (int)chunkZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPike(class_3218 level, class_2338 pos, PikeTier tier, class_1299<?> entityType) {
        List chunkPikes;
        class_5321 dimension = level.method_27983();
        Map dimensionPikes = pikesByDimension.computeIfAbsent((class_5321<class_1937>)dimension, k -> new ConcurrentHashMap());
        int chunkX = pos.method_10263() >> 4;
        int chunkZ = pos.method_10260() >> 4;
        long chunkKey = PikeRegistry.chunkKey(chunkX, chunkZ);
        List list = chunkPikes = dimensionPikes.computeIfAbsent(chunkKey, k -> new ArrayList());
        synchronized (list) {
            for (PikeData existing : chunkPikes) {
                if (!existing.pos().equals((Object)pos)) continue;
                return;
            }
            chunkPikes.add(new PikeData(pos, tier, entityType, chunkX, chunkZ));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterPike(class_3218 level, class_2338 pos) {
        int chunkZ;
        class_5321 dimension = level.method_27983();
        Map<Long, List<PikeData>> dimensionPikes = pikesByDimension.get(dimension);
        if (dimensionPikes == null) {
            return;
        }
        int chunkX = pos.method_10263() >> 4;
        long chunkKey = PikeRegistry.chunkKey(chunkX, chunkZ = pos.method_10260() >> 4);
        List<PikeData> chunkPikes = dimensionPikes.get(chunkKey);
        if (chunkPikes == null) {
            return;
        }
        List<PikeData> list = chunkPikes;
        synchronized (list) {
            chunkPikes.removeIf(pike -> pike.pos().equals((Object)pos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePikeEntityType(class_3218 level, class_2338 pos, class_1299<?> newEntityType) {
        int chunkZ;
        class_5321 dimension = level.method_27983();
        Map<Long, List<PikeData>> dimensionPikes = pikesByDimension.get(dimension);
        if (dimensionPikes == null) {
            return;
        }
        int chunkX = pos.method_10263() >> 4;
        long chunkKey = PikeRegistry.chunkKey(chunkX, chunkZ = pos.method_10260() >> 4);
        List<PikeData> chunkPikes = dimensionPikes.get(chunkKey);
        if (chunkPikes == null) {
            return;
        }
        List<PikeData> list = chunkPikes;
        synchronized (list) {
            for (int i = 0; i < chunkPikes.size(); ++i) {
                PikeData pike = chunkPikes.get(i);
                if (!pike.pos().equals((Object)pos)) continue;
                chunkPikes.set(i, new PikeData(pos, pike.tier(), newEntityType, chunkX, chunkZ));
                return;
            }
        }
    }

    public static void onChunkUnload(class_3218 level, int chunkX, int chunkZ) {
        class_5321 dimension = level.method_27983();
        Map<Long, List<PikeData>> dimensionPikes = pikesByDimension.get(dimension);
        if (dimensionPikes == null) {
            return;
        }
        long chunkKey = PikeRegistry.chunkKey(chunkX, chunkZ);
        dimensionPikes.remove(chunkKey);
    }

    public static void onChunkLoad(class_3218 level, class_2818 chunk) {
        for (class_2586 blockEntity : chunk.method_12214().values()) {
            class_2680 headState;
            class_1299<?> entityType;
            class_2338 pos;
            class_2680 state;
            class_2248 class_22482;
            if (!(blockEntity instanceof PikeBlockEntity) || !((class_22482 = (state = chunk.method_8320(pos = blockEntity.method_11016())).method_26204()) instanceof PikeBlock)) continue;
            PikeBlock pikeBlock = (PikeBlock)class_22482;
            if (!((Boolean)state.method_11654((class_2769)PikeBlock.ACTIVATED)).booleanValue() || (entityType = PikeBlockEntity.getHeadTypeFromBlockState(headState = chunk.method_8320(pos.method_10084()))) == null) continue;
            PikeRegistry.registerPike(level, pos, pikeBlock.tier(), entityType);
        }
    }

    public static void onWorldUnload(class_5321<class_1937> dimension) {
        pikesByDimension.remove(dimension);
    }

    public static void clearAll() {
        pikesByDimension.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static PikeData getBlockingPike(class_3218 level, class_2338 spawnPos, class_1299<?> entityType) {
        class_5321 dimension = level.method_27983();
        Map<Long, List<PikeData>> dimensionPikes = pikesByDimension.get(dimension);
        if (dimensionPikes == null || dimensionPikes.isEmpty()) {
            return null;
        }
        int spawnChunkX = spawnPos.method_10263() >> 4;
        int spawnChunkZ = spawnPos.method_10260() >> 4;
        int maxRadius = PikeRegistry.getMaxChunkRadius();
        for (int dx = -maxRadius; dx <= maxRadius; ++dx) {
            for (int dz = -maxRadius; dz <= maxRadius; ++dz) {
                long chunkKey = PikeRegistry.chunkKey(spawnChunkX + dx, spawnChunkZ + dz);
                List<PikeData> chunkPikes = dimensionPikes.get(chunkKey);
                if (chunkPikes == null || chunkPikes.isEmpty()) continue;
                List<PikeData> list = chunkPikes;
                synchronized (list) {
                    for (PikeData pike : chunkPikes) {
                        int chunkDistance;
                        if (pike.entityType() != entityType || (chunkDistance = Math.max(Math.abs(pike.chunkX() - spawnChunkX), Math.abs(pike.chunkZ() - spawnChunkZ))) > pike.tier().chunkRadius()) continue;
                        return pike;
                    }
                    continue;
                }
            }
        }
        return null;
    }

    public record PikeData(class_2338 pos, PikeTier tier, class_1299<?> entityType, int chunkX, int chunkZ) {
    }
}

