/*
 * Decompiled with CFR 0.152.
 */
package jackperry2187.effigies.block;

import jackperry2187.effigies.PikeRegistry;
import jackperry2187.effigies.PikeTier;
import jackperry2187.effigies.block.entity.PikeBlockEntity;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2484;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;

public class PikeBlock
extends class_2248
implements class_2343 {
    public static final class_2746 ACTIVATED = class_2746.method_11825((String)"activated");
    private static final class_265 SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private final PikeTier tier;

    public PikeBlock(PikeTier tier, class_2960 id) {
        super(tier.blockProperties(id));
        this.tier = tier;
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    public PikeTier tier() {
        return this.tier;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!player.method_5715()) {
            return class_1269.field_5811;
        }
        class_2338 headPos = pos.method_10084();
        class_2680 headState = world.method_8320(headPos);
        if (!PikeBlockEntity.isValidHeadBlock(headState)) {
            return class_1269.field_5811;
        }
        if (!world.method_8608()) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)ACTIVATED, (Comparable)Boolean.valueOf(false)), 3);
            world.method_22352(headPos, true);
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                serverWorld.method_65096((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.5, (double)pos.method_10260() + 0.5, 15, 0.3, 0.4, 0.3, 0.02);
            }
        }
        return class_1269.field_5812;
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_5715()) {
            class_2338 headPos = pos.method_10084();
            class_2680 headState = world.method_8320(headPos);
            if (PikeBlockEntity.isValidHeadBlock(headState)) {
                if (!world.method_8608()) {
                    world.method_8652(pos, (class_2680)state.method_11657((class_2769)ACTIVATED, (Comparable)Boolean.valueOf(false)), 3);
                    world.method_22352(headPos, true);
                    if (world instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)world;
                        serverWorld.method_65096((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.5, (double)pos.method_10260() + 0.5, 15, 0.3, 0.4, 0.3, 0.02);
                    }
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        class_1299<?> headType = PikeBlockEntity.getHeadTypeFromItem(stack);
        if (headType == null) {
            return class_1269.field_5811;
        }
        class_2338 headPos = pos.method_10084();
        if (PikeBlockEntity.isValidHeadBlock(world.method_8320(headPos)) || !this.canPlaceHead(world, headPos)) {
            return class_1269.field_52423;
        }
        class_2680 headState = PikeBlockEntity.getHeadBlockStateForItem(stack);
        if (headState == null) {
            return class_1269.field_5811;
        }
        if (!world.method_8608()) {
            int rotation = class_3532.method_15357((double)((double)(player.method_36454() * 16.0f / 360.0f) + 0.5)) & 0xF;
            headState = (class_2680)headState.method_11657((class_2769)class_2484.field_11505, (Comparable)Integer.valueOf(rotation));
            world.method_8652(headPos, headState, 3);
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)ACTIVATED, (Comparable)Boolean.valueOf(true)), 3);
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
        }
        return class_1269.field_5812;
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.method_8608()) {
            if (((Boolean)state.method_11654((class_2769)ACTIVATED)).booleanValue() && world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                PikeRegistry.unregisterPike(serverWorld, pos);
            }
            this.breakHeadAbove(world, pos);
        }
        return super.method_9576(world, pos, state, player);
    }

    public void method_9586(class_3218 world, class_2338 pos, class_1927 explosion) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26204() instanceof PikeBlock && ((Boolean)state.method_11654((class_2769)ACTIVATED)).booleanValue()) {
            PikeRegistry.unregisterPike(world, pos);
        }
        this.breakHeadAbove((class_1937)world, pos);
        super.method_9586(world, pos, explosion);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (!world.method_8608()) {
            this.updateActivatedState(world, pos, state);
        }
    }

    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, @Nullable class_9904 wireOrientation, boolean notify) {
        super.method_9612(state, world, pos, block, wireOrientation, notify);
        if (!world.method_8608()) {
            this.updateActivatedState(world, pos, state);
        }
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{ACTIVATED});
    }

    @Nullable
    public PikeBlockEntity createBlockEntity(class_2338 pos, class_2680 state) {
        return new PikeBlockEntity(pos, state);
    }

    private void updateActivatedState(class_1937 world, class_2338 pos, class_2680 state) {
        class_2680 headState = world.method_8320(pos.method_10084());
        boolean active = PikeBlockEntity.isValidHeadBlock(headState);
        class_2680 currentWorldState = world.method_8320(pos);
        boolean wasActive = (Boolean)currentWorldState.method_11654((class_2769)ACTIVATED);
        if (wasActive != active) {
            world.method_8652(pos, (class_2680)currentWorldState.method_11657((class_2769)ACTIVATED, (Comparable)Boolean.valueOf(active)), 3);
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                if (active) {
                    class_1299<?> headType = PikeBlockEntity.getHeadTypeFromBlockState(headState);
                    if (headType != null) {
                        PikeRegistry.registerPike(serverWorld, pos, this.tier, headType);
                        serverWorld.method_65096((class_2394)class_2398.field_11240, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.5, (double)pos.method_10260() + 0.5, 15, 0.3, 0.4, 0.3, 0.02);
                    }
                } else {
                    PikeRegistry.unregisterPike(serverWorld, pos);
                    serverWorld.method_65096((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.5, (double)pos.method_10260() + 0.5, 15, 0.3, 0.4, 0.3, 0.02);
                }
            }
        }
    }

    private void breakHeadAbove(class_1937 world, class_2338 pos) {
        class_2338 headPos = pos.method_10084();
        class_2680 headState = world.method_8320(headPos);
        if (PikeBlockEntity.isValidHeadBlock(headState)) {
            world.method_22352(headPos, true);
        }
    }

    private boolean canPlaceHead(class_1937 world, class_2338 headPos) {
        class_2680 state = world.method_8320(headPos);
        return state.method_26215() || state.method_26204() == class_2246.field_10382 || state.method_26204() == class_2246.field_10164;
    }
}

