/*
 * Decompiled with CFR 0.152.
 */
package net.okil.voxelizedfurniture.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.okil.voxelizedfurniture.procedures.OakdoorbellPressedProcedure;

public class JungleDoorbellBlock
extends Block {
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.create((String)"blockstate", (int)0, (int)1);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape SHAPE_1_NORTH = Shapes.or((VoxelShape)JungleDoorbellBlock.box((double)4.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0, (double)16.0), (VoxelShape)JungleDoorbellBlock.box((double)6.0, (double)6.0, (double)13.5, (double)10.0, (double)10.0, (double)14.0));
    private static final VoxelShape SHAPE_1_SOUTH = Shapes.or((VoxelShape)JungleDoorbellBlock.box((double)4.0, (double)2.0, (double)0.0, (double)12.0, (double)14.0, (double)2.0), (VoxelShape)JungleDoorbellBlock.box((double)6.0, (double)6.0, (double)2.0, (double)10.0, (double)10.0, (double)2.5));
    private static final VoxelShape SHAPE_1_EAST = Shapes.or((VoxelShape)JungleDoorbellBlock.box((double)0.0, (double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)12.0), (VoxelShape)JungleDoorbellBlock.box((double)2.0, (double)6.0, (double)6.0, (double)2.5, (double)10.0, (double)10.0));
    private static final VoxelShape SHAPE_1_WEST = Shapes.or((VoxelShape)JungleDoorbellBlock.box((double)14.0, (double)2.0, (double)4.0, (double)16.0, (double)14.0, (double)12.0), (VoxelShape)JungleDoorbellBlock.box((double)13.5, (double)6.0, (double)6.0, (double)14.0, (double)10.0, (double)10.0));
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)JungleDoorbellBlock.box((double)4.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0, (double)16.0), (VoxelShape)JungleDoorbellBlock.box((double)6.0, (double)6.0, (double)12.5, (double)10.0, (double)10.0, (double)14.0));
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)JungleDoorbellBlock.box((double)4.0, (double)2.0, (double)0.0, (double)12.0, (double)14.0, (double)2.0), (VoxelShape)JungleDoorbellBlock.box((double)6.0, (double)6.0, (double)2.0, (double)10.0, (double)10.0, (double)3.5));
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)JungleDoorbellBlock.box((double)0.0, (double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)12.0), (VoxelShape)JungleDoorbellBlock.box((double)2.0, (double)6.0, (double)6.0, (double)3.5, (double)10.0, (double)10.0));
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)JungleDoorbellBlock.box((double)14.0, (double)2.0, (double)4.0, (double)16.0, (double)14.0, (double)12.0), (VoxelShape)JungleDoorbellBlock.box((double)12.5, (double)6.0, (double)6.0, (double)14.0, (double)10.0, (double)10.0));

    public JungleDoorbellBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.WOOD).strength(2.0f, 5.0f).lightLevel(s -> new Object((BlockState)s){
            final /* synthetic */ BlockState val$s;
            {
                this.val$s = blockState;
            }

            public int getLightLevel() {
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 1) {
                    return 0;
                }
                return 0;
            }
        }.getLightLevel()).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 1) {
            return switch ((Direction)state.getValue(FACING)) {
                case Direction.NORTH -> SHAPE_1_NORTH;
                case Direction.SOUTH -> SHAPE_1_SOUTH;
                case Direction.EAST -> SHAPE_1_EAST;
                case Direction.WEST -> SHAPE_1_WEST;
                default -> SHAPE_1_NORTH;
            };
        }
        return switch ((Direction)state.getValue(FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, BLOCKSTATE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        OakdoorbellPressedProcedure.execute((LevelAccessor)world, x, y, z);
        return InteractionResult.SUCCESS;
    }
}

