/*
 * Decompiled with CFR 0.152.
 */
package net.okil.voxelizedfurniture.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.okil.voxelizedfurniture.block.entity.JungleToiletRollBlockEntity;
import net.okil.voxelizedfurniture.procedures.ToiletrollwoolProcedure;

public class JungleToiletRollBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.create((String)"blockstate", (int)0, (int)1);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape SHAPE_1_NORTH = Shapes.or((VoxelShape)JungleToiletRollBlock.box((double)4.0, (double)6.0, (double)15.0, (double)12.0, (double)11.0, (double)16.0), (VoxelShape[])new VoxelShape[]{JungleToiletRollBlock.box((double)4.0, (double)8.25, (double)12.75, (double)12.0, (double)8.75, (double)13.25), JungleToiletRollBlock.box((double)11.5, (double)8.25, (double)13.25, (double)12.0, (double)8.75, (double)15.0), JungleToiletRollBlock.box((double)4.0, (double)8.25, (double)13.25, (double)4.5, (double)8.75, (double)15.0), JungleToiletRollBlock.box((double)5.5, (double)6.75, (double)13.5, (double)10.5, (double)9.75, (double)14.5), JungleToiletRollBlock.box((double)5.5, (double)6.75, (double)11.5, (double)10.5, (double)9.75, (double)12.5), JungleToiletRollBlock.box((double)5.5, (double)8.75, (double)12.5, (double)10.5, (double)9.75, (double)13.5), JungleToiletRollBlock.box((double)5.5, (double)6.75, (double)12.5, (double)10.5, (double)7.75, (double)13.5)});
    private static final VoxelShape SHAPE_1_SOUTH = Shapes.or((VoxelShape)JungleToiletRollBlock.box((double)4.0, (double)6.0, (double)0.0, (double)12.0, (double)11.0, (double)1.0), (VoxelShape[])new VoxelShape[]{JungleToiletRollBlock.box((double)4.0, (double)8.25, (double)2.75, (double)12.0, (double)8.75, (double)3.25), JungleToiletRollBlock.box((double)4.0, (double)8.25, (double)1.0, (double)4.5, (double)8.75, (double)2.75), JungleToiletRollBlock.box((double)11.5, (double)8.25, (double)1.0, (double)12.0, (double)8.75, (double)2.75), JungleToiletRollBlock.box((double)5.5, (double)6.75, (double)1.5, (double)10.5, (double)9.75, (double)2.5), JungleToiletRollBlock.box((double)5.5, (double)6.75, (double)3.5, (double)10.5, (double)9.75, (double)4.5), JungleToiletRollBlock.box((double)5.5, (double)8.75, (double)2.5, (double)10.5, (double)9.75, (double)3.5), JungleToiletRollBlock.box((double)5.5, (double)6.75, (double)2.5, (double)10.5, (double)7.75, (double)3.5)});
    private static final VoxelShape SHAPE_1_EAST = Shapes.or((VoxelShape)JungleToiletRollBlock.box((double)0.0, (double)6.0, (double)4.0, (double)1.0, (double)11.0, (double)12.0), (VoxelShape[])new VoxelShape[]{JungleToiletRollBlock.box((double)2.75, (double)8.25, (double)4.0, (double)3.25, (double)8.75, (double)12.0), JungleToiletRollBlock.box((double)1.0, (double)8.25, (double)11.5, (double)2.75, (double)8.75, (double)12.0), JungleToiletRollBlock.box((double)1.0, (double)8.25, (double)4.0, (double)2.75, (double)8.75, (double)4.5), JungleToiletRollBlock.box((double)1.5, (double)6.75, (double)5.5, (double)2.5, (double)9.75, (double)10.5), JungleToiletRollBlock.box((double)3.5, (double)6.75, (double)5.5, (double)4.5, (double)9.75, (double)10.5), JungleToiletRollBlock.box((double)2.5, (double)8.75, (double)5.5, (double)3.5, (double)9.75, (double)10.5), JungleToiletRollBlock.box((double)2.5, (double)6.75, (double)5.5, (double)3.5, (double)7.75, (double)10.5)});
    private static final VoxelShape SHAPE_1_WEST = Shapes.or((VoxelShape)JungleToiletRollBlock.box((double)15.0, (double)6.0, (double)4.0, (double)16.0, (double)11.0, (double)12.0), (VoxelShape[])new VoxelShape[]{JungleToiletRollBlock.box((double)12.75, (double)8.25, (double)4.0, (double)13.25, (double)8.75, (double)12.0), JungleToiletRollBlock.box((double)13.25, (double)8.25, (double)4.0, (double)15.0, (double)8.75, (double)4.5), JungleToiletRollBlock.box((double)13.25, (double)8.25, (double)11.5, (double)15.0, (double)8.75, (double)12.0), JungleToiletRollBlock.box((double)13.5, (double)6.75, (double)5.5, (double)14.5, (double)9.75, (double)10.5), JungleToiletRollBlock.box((double)11.5, (double)6.75, (double)5.5, (double)12.5, (double)9.75, (double)10.5), JungleToiletRollBlock.box((double)12.5, (double)8.75, (double)5.5, (double)13.5, (double)9.75, (double)10.5), JungleToiletRollBlock.box((double)12.5, (double)6.75, (double)5.5, (double)13.5, (double)7.75, (double)10.5)});
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)JungleToiletRollBlock.box((double)4.0, (double)6.0, (double)15.0, (double)12.0, (double)11.0, (double)16.0), (VoxelShape[])new VoxelShape[]{JungleToiletRollBlock.box((double)4.0, (double)8.25, (double)12.75, (double)12.0, (double)8.75, (double)13.25), JungleToiletRollBlock.box((double)11.5, (double)8.25, (double)13.25, (double)12.0, (double)8.75, (double)15.0), JungleToiletRollBlock.box((double)4.0, (double)8.25, (double)13.25, (double)4.5, (double)8.75, (double)15.0)});
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)JungleToiletRollBlock.box((double)4.0, (double)6.0, (double)0.0, (double)12.0, (double)11.0, (double)1.0), (VoxelShape[])new VoxelShape[]{JungleToiletRollBlock.box((double)4.0, (double)8.25, (double)2.75, (double)12.0, (double)8.75, (double)3.25), JungleToiletRollBlock.box((double)4.0, (double)8.25, (double)1.0, (double)4.5, (double)8.75, (double)2.75), JungleToiletRollBlock.box((double)11.5, (double)8.25, (double)1.0, (double)12.0, (double)8.75, (double)2.75)});
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)JungleToiletRollBlock.box((double)0.0, (double)6.0, (double)4.0, (double)1.0, (double)11.0, (double)12.0), (VoxelShape[])new VoxelShape[]{JungleToiletRollBlock.box((double)2.75, (double)8.25, (double)4.0, (double)3.25, (double)8.75, (double)12.0), JungleToiletRollBlock.box((double)1.0, (double)8.25, (double)11.5, (double)2.75, (double)8.75, (double)12.0), JungleToiletRollBlock.box((double)1.0, (double)8.25, (double)4.0, (double)2.75, (double)8.75, (double)4.5)});
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)JungleToiletRollBlock.box((double)15.0, (double)6.0, (double)4.0, (double)16.0, (double)11.0, (double)12.0), (VoxelShape[])new VoxelShape[]{JungleToiletRollBlock.box((double)12.75, (double)8.25, (double)4.0, (double)13.25, (double)8.75, (double)12.0), JungleToiletRollBlock.box((double)13.25, (double)8.25, (double)4.0, (double)15.0, (double)8.75, (double)4.5), JungleToiletRollBlock.box((double)13.25, (double)8.25, (double)11.5, (double)15.0, (double)8.75, (double)12.0)});

    public JungleToiletRollBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.WOOD).strength(0.5f, 1.0f).lightLevel(s -> new Object((BlockState)s){
            final /* synthetic */ BlockState val$s;
            {
                this.val$s = blockState;
            }

            public int getLightLevel() {
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 1) {
                    return 0;
                }
                return 0;
            }
        }.getLightLevel()).noCollission().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 1) {
            return switch ((Direction)state.getValue(FACING)) {
                case Direction.NORTH -> SHAPE_1_NORTH;
                case Direction.SOUTH -> SHAPE_1_SOUTH;
                case Direction.EAST -> SHAPE_1_EAST;
                case Direction.WEST -> SHAPE_1_WEST;
                default -> SHAPE_1_NORTH;
            };
        }
        return switch ((Direction)state.getValue(FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, BLOCKSTATE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        ToiletrollwoolProcedure.execute((LevelAccessor)world, x, y, z, blockstate, (Entity)entity);
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new JungleToiletRollBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }

    protected void affectNeighborsAfterRemoval(BlockState blockstate, ServerLevel world, BlockPos blockpos, boolean flag) {
        Containers.updateNeighboursAfterDestroy((BlockState)blockstate, (Level)world, (BlockPos)blockpos);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof JungleToiletRollBlockEntity) {
            JungleToiletRollBlockEntity be = (JungleToiletRollBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

