/*
 * Decompiled with CFR 0.152.
 */
package net.okil.voxelizedfurniture.block;

import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.okil.voxelizedfurniture.block.entity.KitchenFridgeBlockEntity;
import net.okil.voxelizedfurniture.world.inventory.FridgeGuiMenu;

public class KitchenFridgeBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)KitchenFridgeBlock.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{KitchenFridgeBlock.box((double)0.0, (double)16.0, (double)3.0, (double)16.0, (double)32.0, (double)16.0), KitchenFridgeBlock.box((double)0.25, (double)16.0, (double)2.0, (double)15.75, (double)31.5, (double)3.0), KitchenFridgeBlock.box((double)14.0, (double)12.0, (double)1.0, (double)15.0, (double)24.0, (double)2.0), KitchenFridgeBlock.box((double)14.0, (double)4.0, (double)1.0, (double)15.0, (double)9.0, (double)2.0), KitchenFridgeBlock.box((double)0.25, (double)11.0, (double)2.0, (double)15.75, (double)16.0, (double)3.0), KitchenFridgeBlock.box((double)0.25, (double)1.0, (double)2.0, (double)15.75, (double)10.0, (double)3.0), KitchenFridgeBlock.box((double)3.0, (double)26.0, (double)1.9, (double)7.0, (double)30.0, (double)2.0)});
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)KitchenFridgeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{KitchenFridgeBlock.box((double)0.0, (double)16.0, (double)0.0, (double)16.0, (double)32.0, (double)13.0), KitchenFridgeBlock.box((double)0.25, (double)16.0, (double)13.0, (double)15.75, (double)31.5, (double)14.0), KitchenFridgeBlock.box((double)1.0, (double)12.0, (double)14.0, (double)2.0, (double)24.0, (double)15.0), KitchenFridgeBlock.box((double)1.0, (double)4.0, (double)14.0, (double)2.0, (double)9.0, (double)15.0), KitchenFridgeBlock.box((double)0.25, (double)11.0, (double)13.0, (double)15.75, (double)16.0, (double)14.0), KitchenFridgeBlock.box((double)0.25, (double)1.0, (double)13.0, (double)15.75, (double)10.0, (double)14.0), KitchenFridgeBlock.box((double)9.0, (double)26.0, (double)14.0, (double)13.0, (double)30.0, (double)14.1)});
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)KitchenFridgeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{KitchenFridgeBlock.box((double)0.0, (double)16.0, (double)0.0, (double)13.0, (double)32.0, (double)16.0), KitchenFridgeBlock.box((double)13.0, (double)16.0, (double)0.25, (double)14.0, (double)31.5, (double)15.75), KitchenFridgeBlock.box((double)14.0, (double)12.0, (double)14.0, (double)15.0, (double)24.0, (double)15.0), KitchenFridgeBlock.box((double)14.0, (double)4.0, (double)14.0, (double)15.0, (double)9.0, (double)15.0), KitchenFridgeBlock.box((double)13.0, (double)11.0, (double)0.25, (double)14.0, (double)16.0, (double)15.75), KitchenFridgeBlock.box((double)13.0, (double)1.0, (double)0.25, (double)14.0, (double)10.0, (double)15.75), KitchenFridgeBlock.box((double)14.0, (double)26.0, (double)3.0, (double)14.1, (double)30.0, (double)7.0)});
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)KitchenFridgeBlock.box((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{KitchenFridgeBlock.box((double)3.0, (double)16.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0), KitchenFridgeBlock.box((double)2.0, (double)16.0, (double)0.25, (double)3.0, (double)31.5, (double)15.75), KitchenFridgeBlock.box((double)1.0, (double)12.0, (double)1.0, (double)2.0, (double)24.0, (double)2.0), KitchenFridgeBlock.box((double)1.0, (double)4.0, (double)1.0, (double)2.0, (double)9.0, (double)2.0), KitchenFridgeBlock.box((double)2.0, (double)11.0, (double)0.25, (double)3.0, (double)16.0, (double)15.75), KitchenFridgeBlock.box((double)2.0, (double)1.0, (double)0.25, (double)3.0, (double)10.0, (double)15.75), KitchenFridgeBlock.box((double)1.9, (double)26.0, (double)9.0, (double)2.0, (double)30.0, (double)13.0)});

    public KitchenFridgeBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(6.0f, 9.0f).requiresCorrectToolForDrops().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, final BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Kitchen Fridge");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new FridgeGuiMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                }
            }, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new KitchenFridgeBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }

    protected void affectNeighborsAfterRemoval(BlockState blockstate, ServerLevel world, BlockPos blockpos, boolean flag) {
        Containers.updateNeighboursAfterDestroy((BlockState)blockstate, (Level)world, (BlockPos)blockpos);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof KitchenFridgeBlockEntity) {
            KitchenFridgeBlockEntity be = (KitchenFridgeBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

