/*
 * Decompiled with CFR 0.152.
 */
package net.okil.voxelizedfurniture.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LaptopBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)LaptopBlock.box((double)14.0, (double)0.75, (double)12.0, (double)14.5, (double)10.75, (double)14.0), (VoxelShape[])new VoxelShape[]{LaptopBlock.box((double)1.5, (double)0.75, (double)12.0, (double)2.0, (double)10.75, (double)14.0), LaptopBlock.box((double)2.0, (double)0.75, (double)12.0, (double)14.0, (double)1.25, (double)14.0), LaptopBlock.box((double)1.5, (double)0.0, (double)2.0, (double)14.5, (double)0.75, (double)12.0), LaptopBlock.box((double)2.5, (double)0.36319, (double)11.85868, (double)3.5, (double)0.66319, (double)13.85868), LaptopBlock.box((double)12.5, (double)0.36319, (double)11.85868, (double)13.5, (double)0.66319, (double)13.85868), LaptopBlock.box((double)2.0, (double)10.25, (double)12.0, (double)14.0, (double)10.75, (double)14.0), LaptopBlock.box((double)2.0, (double)1.25, (double)13.0, (double)14.0, (double)10.25, (double)14.0), LaptopBlock.box((double)2.0, (double)1.25, (double)12.2, (double)14.0, (double)10.25, (double)13.0)});
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)LaptopBlock.box((double)1.5, (double)0.75, (double)2.0, (double)2.0, (double)10.75, (double)4.0), (VoxelShape[])new VoxelShape[]{LaptopBlock.box((double)14.0, (double)0.75, (double)2.0, (double)14.5, (double)10.75, (double)4.0), LaptopBlock.box((double)2.0, (double)0.75, (double)2.0, (double)14.0, (double)1.25, (double)4.0), LaptopBlock.box((double)1.5, (double)0.0, (double)4.0, (double)14.5, (double)0.75, (double)14.0), LaptopBlock.box((double)12.5, (double)0.36319, (double)2.14132, (double)13.5, (double)0.66319, (double)4.14132), LaptopBlock.box((double)2.5, (double)0.36319, (double)2.14132, (double)3.5, (double)0.66319, (double)4.14132), LaptopBlock.box((double)2.0, (double)10.25, (double)2.0, (double)14.0, (double)10.75, (double)4.0), LaptopBlock.box((double)2.0, (double)1.25, (double)2.0, (double)14.0, (double)10.25, (double)3.0), LaptopBlock.box((double)2.0, (double)1.25, (double)3.0, (double)14.0, (double)10.25, (double)3.8)});
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)LaptopBlock.box((double)2.0, (double)0.75, (double)14.0, (double)4.0, (double)10.75, (double)14.5), (VoxelShape[])new VoxelShape[]{LaptopBlock.box((double)2.0, (double)0.75, (double)1.5, (double)4.0, (double)10.75, (double)2.0), LaptopBlock.box((double)2.0, (double)0.75, (double)2.0, (double)4.0, (double)1.25, (double)14.0), LaptopBlock.box((double)4.0, (double)0.0, (double)1.5, (double)14.0, (double)0.75, (double)14.5), LaptopBlock.box((double)2.14132, (double)0.36319, (double)2.5, (double)4.14132, (double)0.66319, (double)3.5), LaptopBlock.box((double)2.14132, (double)0.36319, (double)12.5, (double)4.14132, (double)0.66319, (double)13.5), LaptopBlock.box((double)2.0, (double)10.25, (double)2.0, (double)4.0, (double)10.75, (double)14.0), LaptopBlock.box((double)2.0, (double)1.25, (double)2.0, (double)3.0, (double)10.25, (double)14.0), LaptopBlock.box((double)3.0, (double)1.25, (double)2.0, (double)3.8, (double)10.25, (double)14.0)});
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)LaptopBlock.box((double)12.0, (double)0.75, (double)1.5, (double)14.0, (double)10.75, (double)2.0), (VoxelShape[])new VoxelShape[]{LaptopBlock.box((double)12.0, (double)0.75, (double)14.0, (double)14.0, (double)10.75, (double)14.5), LaptopBlock.box((double)12.0, (double)0.75, (double)2.0, (double)14.0, (double)1.25, (double)14.0), LaptopBlock.box((double)2.0, (double)0.0, (double)1.5, (double)12.0, (double)0.75, (double)14.5), LaptopBlock.box((double)11.85868, (double)0.36319, (double)12.5, (double)13.85868, (double)0.66319, (double)13.5), LaptopBlock.box((double)11.85868, (double)0.36319, (double)2.5, (double)13.85868, (double)0.66319, (double)3.5), LaptopBlock.box((double)12.0, (double)10.25, (double)2.0, (double)14.0, (double)10.75, (double)14.0), LaptopBlock.box((double)13.0, (double)1.25, (double)2.0, (double)14.0, (double)10.25, (double)14.0), LaptopBlock.box((double)12.2, (double)1.25, (double)2.0, (double)13.0, (double)10.25, (double)14.0)});

    public LaptopBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(2.0f, 5.0f).requiresCorrectToolForDrops().noOcclusion().hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }
}

