/*
 * Decompiled with CFR 0.152.
 */
package net.okil.voxelizedfurniture.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.okil.voxelizedfurniture.procedures.LightSwitchProcedure;

public class ModernBulkheadLightOffBlock
extends Block {
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.create((String)"blockstate", (int)0, (int)1);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape SHAPE_1_NORTH = Shapes.or((VoxelShape)ModernBulkheadLightOffBlock.box((double)4.5, (double)1.5, (double)14.0, (double)11.5, (double)14.5, (double)16.0), (VoxelShape[])new VoxelShape[]{ModernBulkheadLightOffBlock.box((double)4.5, (double)1.5, (double)11.0, (double)11.5, (double)3.5, (double)14.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)12.5, (double)11.0, (double)11.5, (double)14.5, (double)14.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)10.5, (double)11.0, (double)11.5, (double)11.5, (double)14.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)8.5, (double)11.0, (double)11.5, (double)9.5, (double)14.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)6.5, (double)11.0, (double)11.5, (double)7.5, (double)14.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)4.5, (double)11.0, (double)11.5, (double)5.5, (double)14.0), ModernBulkheadLightOffBlock.box((double)5.25, (double)3.5, (double)11.75, (double)10.75, (double)12.5, (double)14.0)});
    private static final VoxelShape SHAPE_1_SOUTH = Shapes.or((VoxelShape)ModernBulkheadLightOffBlock.box((double)4.5, (double)1.5, (double)0.0, (double)11.5, (double)14.5, (double)2.0), (VoxelShape[])new VoxelShape[]{ModernBulkheadLightOffBlock.box((double)4.5, (double)1.5, (double)2.0, (double)11.5, (double)3.5, (double)5.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)12.5, (double)2.0, (double)11.5, (double)14.5, (double)5.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)10.5, (double)2.0, (double)11.5, (double)11.5, (double)5.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)8.5, (double)2.0, (double)11.5, (double)9.5, (double)5.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)6.5, (double)2.0, (double)11.5, (double)7.5, (double)5.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)4.5, (double)2.0, (double)11.5, (double)5.5, (double)5.0), ModernBulkheadLightOffBlock.box((double)5.25, (double)3.5, (double)2.0, (double)10.75, (double)12.5, (double)4.25)});
    private static final VoxelShape SHAPE_1_EAST = Shapes.or((VoxelShape)ModernBulkheadLightOffBlock.box((double)0.0, (double)1.5, (double)4.5, (double)2.0, (double)14.5, (double)11.5), (VoxelShape[])new VoxelShape[]{ModernBulkheadLightOffBlock.box((double)2.0, (double)1.5, (double)4.5, (double)5.0, (double)3.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)2.0, (double)12.5, (double)4.5, (double)5.0, (double)14.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)2.0, (double)10.5, (double)4.5, (double)5.0, (double)11.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)2.0, (double)8.5, (double)4.5, (double)5.0, (double)9.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)2.0, (double)6.5, (double)4.5, (double)5.0, (double)7.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)2.0, (double)4.5, (double)4.5, (double)5.0, (double)5.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)2.0, (double)3.5, (double)5.25, (double)4.25, (double)12.5, (double)10.75)});
    private static final VoxelShape SHAPE_1_WEST = Shapes.or((VoxelShape)ModernBulkheadLightOffBlock.box((double)14.0, (double)1.5, (double)4.5, (double)16.0, (double)14.5, (double)11.5), (VoxelShape[])new VoxelShape[]{ModernBulkheadLightOffBlock.box((double)11.0, (double)1.5, (double)4.5, (double)14.0, (double)3.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)11.0, (double)12.5, (double)4.5, (double)14.0, (double)14.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)11.0, (double)10.5, (double)4.5, (double)14.0, (double)11.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)11.0, (double)8.5, (double)4.5, (double)14.0, (double)9.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)11.0, (double)6.5, (double)4.5, (double)14.0, (double)7.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)11.0, (double)4.5, (double)4.5, (double)14.0, (double)5.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)11.75, (double)3.5, (double)5.25, (double)14.0, (double)12.5, (double)10.75)});
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)ModernBulkheadLightOffBlock.box((double)4.5, (double)1.5, (double)14.0, (double)11.5, (double)14.5, (double)16.0), (VoxelShape[])new VoxelShape[]{ModernBulkheadLightOffBlock.box((double)4.5, (double)1.5, (double)11.0, (double)11.5, (double)3.5, (double)14.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)12.5, (double)11.0, (double)11.5, (double)14.5, (double)14.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)10.5, (double)11.0, (double)11.5, (double)11.5, (double)14.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)8.5, (double)11.0, (double)11.5, (double)9.5, (double)14.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)6.5, (double)11.0, (double)11.5, (double)7.5, (double)14.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)4.5, (double)11.0, (double)11.5, (double)5.5, (double)14.0), ModernBulkheadLightOffBlock.box((double)5.25, (double)3.5, (double)11.75, (double)10.75, (double)12.5, (double)14.0)});
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)ModernBulkheadLightOffBlock.box((double)4.5, (double)1.5, (double)0.0, (double)11.5, (double)14.5, (double)2.0), (VoxelShape[])new VoxelShape[]{ModernBulkheadLightOffBlock.box((double)4.5, (double)1.5, (double)2.0, (double)11.5, (double)3.5, (double)5.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)12.5, (double)2.0, (double)11.5, (double)14.5, (double)5.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)10.5, (double)2.0, (double)11.5, (double)11.5, (double)5.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)8.5, (double)2.0, (double)11.5, (double)9.5, (double)5.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)6.5, (double)2.0, (double)11.5, (double)7.5, (double)5.0), ModernBulkheadLightOffBlock.box((double)4.5, (double)4.5, (double)2.0, (double)11.5, (double)5.5, (double)5.0), ModernBulkheadLightOffBlock.box((double)5.25, (double)3.5, (double)2.0, (double)10.75, (double)12.5, (double)4.25)});
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)ModernBulkheadLightOffBlock.box((double)0.0, (double)1.5, (double)4.5, (double)2.0, (double)14.5, (double)11.5), (VoxelShape[])new VoxelShape[]{ModernBulkheadLightOffBlock.box((double)2.0, (double)1.5, (double)4.5, (double)5.0, (double)3.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)2.0, (double)12.5, (double)4.5, (double)5.0, (double)14.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)2.0, (double)10.5, (double)4.5, (double)5.0, (double)11.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)2.0, (double)8.5, (double)4.5, (double)5.0, (double)9.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)2.0, (double)6.5, (double)4.5, (double)5.0, (double)7.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)2.0, (double)4.5, (double)4.5, (double)5.0, (double)5.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)2.0, (double)3.5, (double)5.25, (double)4.25, (double)12.5, (double)10.75)});
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)ModernBulkheadLightOffBlock.box((double)14.0, (double)1.5, (double)4.5, (double)16.0, (double)14.5, (double)11.5), (VoxelShape[])new VoxelShape[]{ModernBulkheadLightOffBlock.box((double)11.0, (double)1.5, (double)4.5, (double)14.0, (double)3.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)11.0, (double)12.5, (double)4.5, (double)14.0, (double)14.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)11.0, (double)10.5, (double)4.5, (double)14.0, (double)11.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)11.0, (double)8.5, (double)4.5, (double)14.0, (double)9.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)11.0, (double)6.5, (double)4.5, (double)14.0, (double)7.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)11.0, (double)4.5, (double)4.5, (double)14.0, (double)5.5, (double)11.5), ModernBulkheadLightOffBlock.box((double)11.75, (double)3.5, (double)5.25, (double)14.0, (double)12.5, (double)10.75)});

    public ModernBulkheadLightOffBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.GLASS).strength(2.0f, 3.0f).lightLevel(s -> new Object((BlockState)s){
            final /* synthetic */ BlockState val$s;
            {
                this.val$s = blockState;
            }

            public int getLightLevel() {
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 1) {
                    return 10;
                }
                return 0;
            }
        }.getLightLevel()).requiresCorrectToolForDrops().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 1) {
            return switch ((Direction)state.getValue(FACING)) {
                case Direction.NORTH -> SHAPE_1_NORTH;
                case Direction.SOUTH -> SHAPE_1_SOUTH;
                case Direction.EAST -> SHAPE_1_EAST;
                case Direction.WEST -> SHAPE_1_WEST;
                default -> SHAPE_1_NORTH;
            };
        }
        return switch ((Direction)state.getValue(FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, BLOCKSTATE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        LightSwitchProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }
}

