/*
 * Decompiled with CFR 0.152.
 */
package net.okil.voxelizedfurniture.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OakCobblePathBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)OakCobblePathBlock.box((double)-1.0, (double)0.0, (double)-6.0, (double)21.0, (double)9.0, (double)22.0), (VoxelShape[])new VoxelShape[]{OakCobblePathBlock.box((double)0.0, (double)0.0, (double)11.0, (double)9.0, (double)8.0, (double)20.0), OakCobblePathBlock.box((double)5.0, (double)0.0, (double)17.0, (double)20.0, (double)9.0, (double)26.0), OakCobblePathBlock.box((double)-2.0, (double)0.0, (double)-14.0, (double)14.0, (double)4.0, (double)-5.0), OakCobblePathBlock.box((double)-3.0, (double)0.0, (double)19.0, (double)18.0, (double)4.0, (double)32.0), OakCobblePathBlock.box((double)11.0, (double)0.0, (double)-15.0, (double)20.0, (double)4.0, (double)-6.0), OakCobblePathBlock.box((double)12.0, (double)0.0, (double)23.0, (double)21.0, (double)3.0, (double)32.0), OakCobblePathBlock.box((double)0.0, (double)0.0, (double)-9.0, (double)22.0, (double)7.0, (double)0.0)});
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)OakCobblePathBlock.box((double)-5.0, (double)0.0, (double)-6.0, (double)17.0, (double)9.0, (double)22.0), (VoxelShape[])new VoxelShape[]{OakCobblePathBlock.box((double)7.0, (double)0.0, (double)-4.0, (double)16.0, (double)8.0, (double)5.0), OakCobblePathBlock.box((double)-4.0, (double)0.0, (double)-10.0, (double)11.0, (double)9.0, (double)-1.0), OakCobblePathBlock.box((double)2.0, (double)0.0, (double)21.0, (double)18.0, (double)4.0, (double)30.0), OakCobblePathBlock.box((double)-2.0, (double)0.0, (double)-16.0, (double)19.0, (double)4.0, (double)-3.0), OakCobblePathBlock.box((double)-4.0, (double)0.0, (double)22.0, (double)5.0, (double)4.0, (double)31.0), OakCobblePathBlock.box((double)-5.0, (double)0.0, (double)-16.0, (double)4.0, (double)3.0, (double)-7.0), OakCobblePathBlock.box((double)-6.0, (double)0.0, (double)16.0, (double)16.0, (double)7.0, (double)25.0)});
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)OakCobblePathBlock.box((double)-6.0, (double)0.0, (double)-1.0, (double)22.0, (double)9.0, (double)21.0), (VoxelShape[])new VoxelShape[]{OakCobblePathBlock.box((double)-4.0, (double)0.0, (double)0.0, (double)5.0, (double)8.0, (double)9.0), OakCobblePathBlock.box((double)-10.0, (double)0.0, (double)5.0, (double)-1.0, (double)9.0, (double)20.0), OakCobblePathBlock.box((double)21.0, (double)0.0, (double)-2.0, (double)30.0, (double)4.0, (double)14.0), OakCobblePathBlock.box((double)-16.0, (double)0.0, (double)-3.0, (double)-3.0, (double)4.0, (double)18.0), OakCobblePathBlock.box((double)22.0, (double)0.0, (double)11.0, (double)31.0, (double)4.0, (double)20.0), OakCobblePathBlock.box((double)-16.0, (double)0.0, (double)12.0, (double)-7.0, (double)3.0, (double)21.0), OakCobblePathBlock.box((double)16.0, (double)0.0, (double)0.0, (double)25.0, (double)7.0, (double)22.0)});
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)OakCobblePathBlock.box((double)-6.0, (double)0.0, (double)-5.0, (double)22.0, (double)9.0, (double)17.0), (VoxelShape[])new VoxelShape[]{OakCobblePathBlock.box((double)11.0, (double)0.0, (double)7.0, (double)20.0, (double)8.0, (double)16.0), OakCobblePathBlock.box((double)17.0, (double)0.0, (double)-4.0, (double)26.0, (double)9.0, (double)11.0), OakCobblePathBlock.box((double)-14.0, (double)0.0, (double)2.0, (double)-5.0, (double)4.0, (double)18.0), OakCobblePathBlock.box((double)19.0, (double)0.0, (double)-2.0, (double)32.0, (double)4.0, (double)19.0), OakCobblePathBlock.box((double)-15.0, (double)0.0, (double)-4.0, (double)-6.0, (double)4.0, (double)5.0), OakCobblePathBlock.box((double)23.0, (double)0.0, (double)-5.0, (double)32.0, (double)3.0, (double)4.0), OakCobblePathBlock.box((double)-9.0, (double)0.0, (double)-6.0, (double)0.0, (double)7.0, (double)16.0)});

    public OakCobblePathBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(15.0f, 10.0f).requiresCorrectToolForDrops().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }
}

