/*
 * Decompiled with CFR 0.152.
 */
package net.okil.voxelizedfurniture.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TvBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)TvBlock.box((double)17.0, (double)2.0, (double)14.0, (double)17.5, (double)14.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TvBlock.box((double)-1.5, (double)2.0, (double)14.0, (double)-1.0, (double)14.0, (double)16.0), TvBlock.box((double)-1.0, (double)2.0, (double)14.0, (double)17.0, (double)2.5, (double)16.0), TvBlock.box((double)-1.0, (double)13.5, (double)14.0, (double)17.0, (double)14.0, (double)16.0), TvBlock.box((double)-1.0, (double)2.5, (double)15.0, (double)17.0, (double)13.5, (double)16.0), TvBlock.box((double)-1.0, (double)2.5, (double)14.2, (double)17.0, (double)13.5, (double)15.0)});
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)TvBlock.box((double)-1.5, (double)2.0, (double)0.0, (double)-1.0, (double)14.0, (double)2.0), (VoxelShape[])new VoxelShape[]{TvBlock.box((double)17.0, (double)2.0, (double)0.0, (double)17.5, (double)14.0, (double)2.0), TvBlock.box((double)-1.0, (double)2.0, (double)0.0, (double)17.0, (double)2.5, (double)2.0), TvBlock.box((double)-1.0, (double)13.5, (double)0.0, (double)17.0, (double)14.0, (double)2.0), TvBlock.box((double)-1.0, (double)2.5, (double)0.0, (double)17.0, (double)13.5, (double)1.0), TvBlock.box((double)-1.0, (double)2.5, (double)1.0, (double)17.0, (double)13.5, (double)1.8)});
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)TvBlock.box((double)0.0, (double)2.0, (double)17.0, (double)2.0, (double)14.0, (double)17.5), (VoxelShape[])new VoxelShape[]{TvBlock.box((double)0.0, (double)2.0, (double)-1.5, (double)2.0, (double)14.0, (double)-1.0), TvBlock.box((double)0.0, (double)2.0, (double)-1.0, (double)2.0, (double)2.5, (double)17.0), TvBlock.box((double)0.0, (double)13.5, (double)-1.0, (double)2.0, (double)14.0, (double)17.0), TvBlock.box((double)0.0, (double)2.5, (double)-1.0, (double)1.0, (double)13.5, (double)17.0), TvBlock.box((double)1.0, (double)2.5, (double)-1.0, (double)1.8, (double)13.5, (double)17.0)});
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)TvBlock.box((double)14.0, (double)2.0, (double)-1.5, (double)16.0, (double)14.0, (double)-1.0), (VoxelShape[])new VoxelShape[]{TvBlock.box((double)14.0, (double)2.0, (double)17.0, (double)16.0, (double)14.0, (double)17.5), TvBlock.box((double)14.0, (double)2.0, (double)-1.0, (double)16.0, (double)2.5, (double)17.0), TvBlock.box((double)14.0, (double)13.5, (double)-1.0, (double)16.0, (double)14.0, (double)17.0), TvBlock.box((double)15.0, (double)2.5, (double)-1.0, (double)16.0, (double)13.5, (double)17.0), TvBlock.box((double)14.2, (double)2.5, (double)-1.0, (double)15.0, (double)13.5, (double)17.0)});

    public TvBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(1.5f, 6.0f).requiresCorrectToolForDrops().noOcclusion().hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }
}

