/*
 * Decompiled with CFR 0.152.
 */
package net.okil.voxelizedfurniture.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.okil.voxelizedfurniture.entity.AcaciaChairEntity;
import net.okil.voxelizedfurniture.entity.BambooChairEntity;
import net.okil.voxelizedfurniture.entity.BirchChairEntity;
import net.okil.voxelizedfurniture.entity.CherryChairEntity;
import net.okil.voxelizedfurniture.entity.DarkOakChairEntity;
import net.okil.voxelizedfurniture.entity.JungleChairEntity;
import net.okil.voxelizedfurniture.entity.MangroveChairEntity;
import net.okil.voxelizedfurniture.entity.OakChairEntity;
import net.okil.voxelizedfurniture.entity.SpruceChairEntity;

@EventBusSubscriber
public class VoxelizedFurnitureModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"voxelized_furniture");
    public static final DeferredHolder<EntityType<?>, EntityType<OakChairEntity>> OAK_CHAIR = VoxelizedFurnitureModEntities.register("oak_chair", EntityType.Builder.of(OakChairEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.25f));
    public static final DeferredHolder<EntityType<?>, EntityType<SpruceChairEntity>> SPRUCE_CHAIR = VoxelizedFurnitureModEntities.register("spruce_chair", EntityType.Builder.of(SpruceChairEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.25f));
    public static final DeferredHolder<EntityType<?>, EntityType<MangroveChairEntity>> MANGROVE_CHAIR = VoxelizedFurnitureModEntities.register("mangrove_chair", EntityType.Builder.of(MangroveChairEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.25f));
    public static final DeferredHolder<EntityType<?>, EntityType<JungleChairEntity>> JUNGLE_CHAIR = VoxelizedFurnitureModEntities.register("jungle_chair", EntityType.Builder.of(JungleChairEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.25f));
    public static final DeferredHolder<EntityType<?>, EntityType<DarkOakChairEntity>> DARK_OAK_CHAIR = VoxelizedFurnitureModEntities.register("dark_oak_chair", EntityType.Builder.of(DarkOakChairEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.25f));
    public static final DeferredHolder<EntityType<?>, EntityType<CherryChairEntity>> CHERRY_CHAIR = VoxelizedFurnitureModEntities.register("cherry_chair", EntityType.Builder.of(CherryChairEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.25f));
    public static final DeferredHolder<EntityType<?>, EntityType<BirchChairEntity>> BIRCH_CHAIR = VoxelizedFurnitureModEntities.register("birch_chair", EntityType.Builder.of(BirchChairEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.25f));
    public static final DeferredHolder<EntityType<?>, EntityType<BambooChairEntity>> BAMBOO_CHAIR = VoxelizedFurnitureModEntities.register("bamboo_chair", EntityType.Builder.of(BambooChairEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.25f));
    public static final DeferredHolder<EntityType<?>, EntityType<AcaciaChairEntity>> ACACIA_CHAIR = VoxelizedFurnitureModEntities.register("acacia_chair", EntityType.Builder.of(AcaciaChairEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.25f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"voxelized_furniture", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        OakChairEntity.init(event);
        SpruceChairEntity.init(event);
        MangroveChairEntity.init(event);
        JungleChairEntity.init(event);
        DarkOakChairEntity.init(event);
        CherryChairEntity.init(event);
        BirchChairEntity.init(event);
        BambooChairEntity.init(event);
        AcaciaChairEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)OAK_CHAIR.get(), OakChairEntity.createAttributes().build());
        event.put((EntityType)SPRUCE_CHAIR.get(), SpruceChairEntity.createAttributes().build());
        event.put((EntityType)MANGROVE_CHAIR.get(), MangroveChairEntity.createAttributes().build());
        event.put((EntityType)JUNGLE_CHAIR.get(), JungleChairEntity.createAttributes().build());
        event.put((EntityType)DARK_OAK_CHAIR.get(), DarkOakChairEntity.createAttributes().build());
        event.put((EntityType)CHERRY_CHAIR.get(), CherryChairEntity.createAttributes().build());
        event.put((EntityType)BIRCH_CHAIR.get(), BirchChairEntity.createAttributes().build());
        event.put((EntityType)BAMBOO_CHAIR.get(), BambooChairEntity.createAttributes().build());
        event.put((EntityType)ACACIA_CHAIR.get(), AcaciaChairEntity.createAttributes().build());
    }
}

