/*
 * Decompiled with CFR 0.152.
 */
package dev.footstepstrail.forge;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.brigadier.CommandDispatcher;
import dev.footstepstrail.FootstepsTrail;
import dev.footstepstrail.config.FootstepsConfig;
import dev.footstepstrail.forge.command.FootstepsCommand;
import dev.footstepstrail.render.FootstepsRenderer;
import dev.footstepstrail.tracking.FootstepsTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public final class FootstepsTrailForgeClient {
    private static KeyMapping toggleKey;

    private FootstepsTrailForgeClient() {
    }

    public static void init() {
        FootstepsTrail.LOGGER.info("Initializing Footsteps Trail (Forge client)");
        FootstepsConfig.getInstance();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(FootstepsTrailForgeClient::onRegisterKeyMappings);
        MinecraftForge.EVENT_BUS.addListener(FootstepsTrailForgeClient::onClientTick);
        MinecraftForge.EVENT_BUS.addListener(FootstepsTrailForgeClient::onRenderLevelStage);
        MinecraftForge.EVENT_BUS.addListener(FootstepsTrailForgeClient::onRegisterClientCommands);
    }

    private static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        toggleKey = new KeyMapping("key.footstepstrail.toggle", InputConstants.Type.KEYSYM, 66, "key.category.footstepstrail");
        event.register(toggleKey);
    }

    private static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (toggleKey != null && toggleKey.m_90859_()) {
            FootstepsConfig config = FootstepsConfig.getInstance();
            config.toggle();
            config.save();
            if (!config.isEnabled()) {
                FootstepsTracker.getInstance().clear();
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                String key = config.isEnabled() ? "text.footstepstrail.toggle.enabled" : "text.footstepstrail.toggle.disabled";
                mc.f_91074_.m_5661_((Component)Component.m_237115_((String)key), true);
            }
        }
        FootstepsTracker.getInstance().tick();
    }

    private static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        FootstepsRenderer.getInstance().render(event.getPoseStack(), event.getCamera());
    }

    private static void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        FootstepsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

