/*
 * Decompiled with CFR 0.152.
 */
package dev.footstepstrail.forge.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.footstepstrail.config.FootprintPlacementMode;
import dev.footstepstrail.config.FootstepsConfig;
import dev.footstepstrail.config.TrackingMode;
import dev.footstepstrail.tracking.FootstepsTracker;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public final class FootstepsCommand {
    private static final String[] COLOR_OPTIONS = new String[]{"white", "gray", "red", "green", "blue", "yellow"};

    private FootstepsCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"footsteps").executes(ctx -> FootstepsCommand.executeStatus((CommandSourceStack)ctx.getSource()))).then(Commands.m_82127_((String)"toggle").executes(ctx -> FootstepsCommand.executeToggle((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"mode").then(Commands.m_82129_((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"time", "steps"}, (SuggestionsBuilder)builder)).executes(ctx -> FootstepsCommand.executeMode((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"mode")))))).then(Commands.m_82127_((String)"placement").then(Commands.m_82129_((String)"placement", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"ground", "continuous"}, (SuggestionsBuilder)builder)).executes(ctx -> FootstepsCommand.executePlacement((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"placement")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"config").then(Commands.m_82127_((String)"time").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1, (int)300)).executes(ctx -> FootstepsCommand.executeDuration((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds"))))))).then(Commands.m_82127_((String)"steps").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)500)).executes(ctx -> FootstepsCommand.executeSteps((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count")))))))).then(Commands.m_82127_((String)"color").then(Commands.m_82129_((String)"color", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.m_82967_((String[])COLOR_OPTIONS, (SuggestionsBuilder)builder)).executes(ctx -> FootstepsCommand.executeColor((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"color")))))).then(Commands.m_82127_((String)"size").then(Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.05f, (float)2.0f)).executes(ctx -> FootstepsCommand.executeSize((CommandSourceStack)ctx.getSource(), FloatArgumentType.getFloat((CommandContext)ctx, (String)"value")))))).then(Commands.m_82127_((String)"clear").executes(ctx -> FootstepsCommand.executeClear((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"status").executes(ctx -> FootstepsCommand.executeStatus((CommandSourceStack)ctx.getSource()))));
    }

    private static void sendChat(CommandSourceStack source, Component message) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            mc.f_91074_.m_5661_(message, false);
        } else {
            source.m_288197_(() -> message, false);
        }
    }

    private static int executeToggle(CommandSourceStack source) {
        FootstepsConfig config = FootstepsConfig.getInstance();
        config.toggle();
        config.save();
        String status = config.isEnabled() ? "enabled" : "disabled";
        ChatFormatting color = config.isEnabled() ? ChatFormatting.GREEN : ChatFormatting.RED;
        FootstepsCommand.sendChat(source, (Component)Component.m_237110_((String)"text.footstepstrail.command.toggle", (Object[])new Object[]{Component.m_237113_((String)status).m_130940_(color)}).m_130940_(ChatFormatting.GREEN));
        if (!config.isEnabled()) {
            FootstepsTracker.getInstance().clear();
        }
        return 1;
    }

    private static int executeMode(CommandSourceStack source, String modeStr) {
        TrackingMode mode;
        FootstepsConfig config = FootstepsConfig.getInstance();
        try {
            mode = TrackingMode.valueOf(modeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            FootstepsCommand.sendChat(source, (Component)Component.m_237115_((String)"text.footstepstrail.command.invalid_mode").m_130940_(ChatFormatting.RED));
            return 0;
        }
        config.setTrackingMode(mode);
        config.save();
        FootstepsTracker.getInstance().clear();
        FootstepsCommand.sendChat(source, (Component)Component.m_237110_((String)"text.footstepstrail.command.mode", (Object[])new Object[]{Component.m_237113_((String)mode.name().toLowerCase()).m_130940_(ChatFormatting.AQUA)}));
        return 1;
    }

    private static int executePlacement(CommandSourceStack source, String placementStr) {
        FootprintPlacementMode placementMode;
        String normalized;
        FootstepsConfig config = FootstepsConfig.getInstance();
        switch (normalized = placementStr.toLowerCase()) {
            case "ground": 
            case "ground_only": 
            case "groundonly": {
                placementMode = FootprintPlacementMode.GROUND_ONLY;
                break;
            }
            case "continuous": 
            case "legacy": 
            case "classic": {
                placementMode = FootprintPlacementMode.CONTINUOUS;
                break;
            }
            default: {
                FootstepsCommand.sendChat(source, (Component)Component.m_237115_((String)"text.footstepstrail.command.invalid_placement").m_130940_(ChatFormatting.RED));
                return 0;
            }
        }
        config.setPlacementMode(placementMode);
        config.save();
        FootstepsTracker.getInstance().clear();
        FootstepsCommand.sendChat(source, (Component)Component.m_237110_((String)"text.footstepstrail.command.placement", (Object[])new Object[]{Component.m_237113_((String)placementMode.name().toLowerCase()).m_130940_(ChatFormatting.AQUA)}));
        return 1;
    }

    private static int executeDuration(CommandSourceStack source, int seconds) {
        FootstepsConfig config = FootstepsConfig.getInstance();
        config.setMaxDurationSeconds(seconds);
        config.save();
        FootstepsCommand.sendChat(source, (Component)Component.m_237110_((String)"text.footstepstrail.command.duration", (Object[])new Object[]{seconds}).m_130940_(ChatFormatting.GREEN));
        return 1;
    }

    private static int executeSteps(CommandSourceStack source, int count) {
        FootstepsConfig config = FootstepsConfig.getInstance();
        config.setMaxSteps(count);
        config.save();
        FootstepsCommand.sendChat(source, (Component)Component.m_237110_((String)"text.footstepstrail.command.steps", (Object[])new Object[]{count}).m_130940_(ChatFormatting.GREEN));
        return 1;
    }

    private static int executeColor(CommandSourceStack source, String colorName) {
        String normalized;
        FootstepsConfig config = FootstepsConfig.getInstance();
        switch (normalized = colorName.toLowerCase()) {
            case "white": {
                config.setColor(1.0f, 1.0f, 1.0f);
                break;
            }
            case "gray": 
            case "grey": {
                config.setColor(0.7f, 0.7f, 0.7f);
                normalized = "gray";
                break;
            }
            case "red": {
                config.setColor(1.0f, 0.2f, 0.2f);
                break;
            }
            case "green": {
                config.setColor(0.2f, 1.0f, 0.2f);
                break;
            }
            case "blue": {
                config.setColor(0.2f, 0.4f, 1.0f);
                break;
            }
            case "yellow": {
                config.setColor(1.0f, 1.0f, 0.2f);
                break;
            }
            default: {
                FootstepsCommand.sendChat(source, (Component)Component.m_237115_((String)"text.footstepstrail.command.invalid_color").m_130940_(ChatFormatting.RED));
                return 0;
            }
        }
        config.save();
        FootstepsCommand.sendChat(source, (Component)Component.m_237110_((String)"text.footstepstrail.command.color", (Object[])new Object[]{Component.m_237113_((String)normalized).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.GREEN));
        return 1;
    }

    private static int executeSize(CommandSourceStack source, float value) {
        FootstepsConfig config = FootstepsConfig.getInstance();
        config.setMarkerSize(value);
        config.save();
        FootstepsCommand.sendChat(source, (Component)Component.m_237110_((String)"text.footstepstrail.command.size", (Object[])new Object[]{Float.valueOf(value)}).m_130940_(ChatFormatting.GREEN));
        return 1;
    }

    private static int executeClear(CommandSourceStack source) {
        FootstepsTracker.getInstance().clear();
        FootstepsCommand.sendChat(source, (Component)Component.m_237115_((String)"text.footstepstrail.command.clear").m_130940_(ChatFormatting.YELLOW));
        return 1;
    }

    private static int executeStatus(CommandSourceStack source) {
        FootstepsConfig config = FootstepsConfig.getInstance();
        FootstepsTracker tracker = FootstepsTracker.getInstance();
        String enabledStr = config.isEnabled() ? "Enabled" : "Disabled";
        ChatFormatting enabledColor = config.isEnabled() ? ChatFormatting.GREEN : ChatFormatting.RED;
        FootstepsCommand.sendChat(source, (Component)Component.m_237115_((String)"text.footstepstrail.status.title").m_130940_(ChatFormatting.GOLD));
        FootstepsCommand.sendChat(source, (Component)Component.m_237110_((String)"text.footstepstrail.status.status", (Object[])new Object[]{Component.m_237113_((String)enabledStr).m_130940_(enabledColor)}));
        FootstepsCommand.sendChat(source, (Component)Component.m_237110_((String)"text.footstepstrail.status.mode", (Object[])new Object[]{Component.m_237113_((String)config.getTrackingMode().name().toLowerCase()).m_130940_(ChatFormatting.AQUA)}));
        FootstepsCommand.sendChat(source, (Component)Component.m_237110_((String)"text.footstepstrail.status.placement", (Object[])new Object[]{Component.m_237113_((String)config.getPlacementMode().name().toLowerCase()).m_130940_(ChatFormatting.AQUA)}));
        if (config.getTrackingMode() == TrackingMode.TIME) {
            FootstepsCommand.sendChat(source, (Component)Component.m_237110_((String)"text.footstepstrail.status.duration", (Object[])new Object[]{String.valueOf(config.getMaxDurationSeconds())}).m_130940_(ChatFormatting.AQUA));
        } else {
            FootstepsCommand.sendChat(source, (Component)Component.m_237110_((String)"text.footstepstrail.status.steps", (Object[])new Object[]{String.valueOf(config.getMaxSteps())}).m_130940_(ChatFormatting.AQUA));
        }
        FootstepsCommand.sendChat(source, (Component)Component.m_237110_((String)"text.footstepstrail.status.color", (Object[])new Object[]{(int)(config.getColorR() * 255.0f), (int)(config.getColorG() * 255.0f), (int)(config.getColorB() * 255.0f)}).m_130940_(ChatFormatting.AQUA));
        FootstepsCommand.sendChat(source, (Component)Component.m_237110_((String)"text.footstepstrail.status.size", (Object[])new Object[]{Float.valueOf(config.getMarkerSize())}).m_130940_(ChatFormatting.AQUA));
        FootstepsCommand.sendChat(source, (Component)Component.m_237110_((String)"text.footstepstrail.status.opacity", (Object[])new Object[]{Float.valueOf(config.getMaxOpacity())}).m_130940_(ChatFormatting.AQUA));
        FootstepsCommand.sendChat(source, (Component)Component.m_237110_((String)"text.footstepstrail.status.active", (Object[])new Object[]{tracker.getCount()}).m_130940_(ChatFormatting.YELLOW));
        return 1;
    }
}

