/*
 * Decompiled with CFR 0.152.
 */
package dev.footstepstrail.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.footstepstrail.config.FootstepsConfig;
import dev.footstepstrail.config.TrackingMode;
import dev.footstepstrail.tracking.Footstep;
import dev.footstepstrail.tracking.FootstepsTracker;
import java.util.Iterator;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;

public class FootstepsRenderer {
    private static FootstepsRenderer INSTANCE;
    private static final float HEIGHT_OFFSET = 0.02f;

    private FootstepsRenderer() {
    }

    public static FootstepsRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FootstepsRenderer();
        }
        return INSTANCE;
    }

    public void render(PoseStack matrices, Camera camera) {
        FootstepsConfig config = FootstepsConfig.getInstance();
        if (!config.isEnabled()) {
            return;
        }
        FootstepsTracker tracker = FootstepsTracker.getInstance();
        int totalFootsteps = tracker.getCount();
        if (totalFootsteps == 0) {
            return;
        }
        double camX = camera.m_90583_().f_82479_;
        double camY = camera.m_90583_().f_82480_;
        double camZ = camera.m_90583_().f_82481_;
        matrices.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        long now = System.currentTimeMillis();
        int maxDurationMs = config.getMaxDurationSeconds() * 1000;
        float markerHalfSize = config.getMarkerSize();
        float maxOpacity = config.getMaxOpacity();
        int r = (int)(config.getColorR() * 255.0f);
        int g = (int)(config.getColorG() * 255.0f);
        int b = (int)(config.getColorB() * 255.0f);
        Iterator<Footstep> iterator = tracker.getFootsteps();
        int index = 0;
        while (iterator.hasNext()) {
            float opacity;
            Footstep footstep = iterator.next();
            if (config.getTrackingMode() == TrackingMode.TIME) {
                long age = now - footstep.getTimestamp();
                float normalizedAge = (float)age / (float)maxDurationMs;
                normalizedAge = Math.min(1.0f, Math.max(0.0f, normalizedAge));
                opacity = (1.0f - normalizedAge) * maxOpacity;
            } else {
                float normalizedIndex = (float)index / (float)totalFootsteps;
                opacity = (1.0f - normalizedIndex) * maxOpacity;
            }
            ++index;
            if (opacity < 0.01f) continue;
            float x = (float)(footstep.getX() - camX);
            float y = (float)(footstep.getY() - camY + (double)0.02f);
            float z = (float)(footstep.getZ() - camZ);
            Matrix4f matrix = matrices.m_85850_().m_252922_();
            int a = (int)(opacity * 255.0f);
            buffer.m_252986_(matrix, x - markerHalfSize, y, z - markerHalfSize).m_6122_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, x - markerHalfSize, y, z + markerHalfSize).m_6122_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, x + markerHalfSize, y, z + markerHalfSize).m_6122_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, x + markerHalfSize, y, z - markerHalfSize).m_6122_(r, g, b, a).m_5752_();
        }
        tessellator.m_85914_();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        matrices.m_85849_();
    }
}

