/*
 * Decompiled with CFR 0.152.
 */
package dev.footstepstrail.tracking;

import dev.footstepstrail.config.FootprintPlacementMode;
import dev.footstepstrail.config.FootstepsConfig;
import dev.footstepstrail.config.TrackingMode;
import dev.footstepstrail.tracking.Footstep;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class FootstepsTracker {
    private static FootstepsTracker INSTANCE;
    private final Deque<Footstep> footsteps = new ArrayDeque<Footstep>();
    private int stepCounter = 0;
    private double lastX = Double.NaN;
    private double lastY = Double.NaN;
    private double lastZ = Double.NaN;

    private FootstepsTracker() {
    }

    public static FootstepsTracker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FootstepsTracker();
        }
        return INSTANCE;
    }

    public void tick() {
        FootstepsConfig config = FootstepsConfig.getInstance();
        if (!config.isEnabled()) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer player = client.f_91074_;
        if (player == null || client.f_91073_ == null) {
            return;
        }
        Vec3 candidate = this.getCandidateFootstepPos(player, client.f_91073_, config);
        if (candidate != null && this.shouldRecordFootstep(candidate.f_82479_, candidate.f_82480_, candidate.f_82481_, config)) {
            this.recordFootstep(candidate.f_82479_, candidate.f_82480_, candidate.f_82481_);
        }
        this.removeExpiredFootsteps(config);
    }

    private Vec3 getCandidateFootstepPos(LocalPlayer player, ClientLevel world, FootstepsConfig config) {
        Vec3 end;
        FootprintPlacementMode placementMode = config.getPlacementMode();
        if (placementMode == FootprintPlacementMode.CONTINUOUS) {
            return new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_());
        }
        if (!player.m_20096_()) {
            return null;
        }
        if (player.m_20069_() || player.m_5842_() || player.m_20077_()) {
            return null;
        }
        Vec3 start = player.m_20182_().m_82520_(0.0, 0.1, 0.0);
        BlockHitResult hit = world.m_45547_(new ClipContext(start, end = start.m_82520_(0.0, -2.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        if (hit.m_6662_() != HitResult.Type.BLOCK) {
            return null;
        }
        Vec3 hitPos = hit.m_82450_();
        return new Vec3(hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_);
    }

    private boolean shouldRecordFootstep(double x, double y, double z, FootstepsConfig config) {
        if (Double.isNaN(this.lastX)) {
            return true;
        }
        double dx = x - this.lastX;
        double dy = y - this.lastY;
        double dz = z - this.lastZ;
        double distSquared = dx * dx + dy * dy + dz * dz;
        double minDist = config.getMinDistanceForStep();
        double minDistSquared = minDist * minDist;
        return distSquared >= minDistSquared;
    }

    private void recordFootstep(double x, double y, double z) {
        long now = System.currentTimeMillis();
        Footstep footstep = new Footstep(x, y, z, now, this.stepCounter++);
        this.footsteps.addFirst(footstep);
        this.lastX = x;
        this.lastY = y;
        this.lastZ = z;
    }

    private void removeExpiredFootsteps(FootstepsConfig config) {
        if (config.getTrackingMode() == TrackingMode.TIME) {
            this.removeByTime(config.getMaxDurationSeconds());
        } else {
            this.removeBySteps(config.getMaxSteps());
        }
    }

    private void removeByTime(int maxDurationSeconds) {
        Footstep oldest;
        long now = System.currentTimeMillis();
        long maxAgeMs = (long)maxDurationSeconds * 1000L;
        while (!this.footsteps.isEmpty() && (oldest = this.footsteps.peekLast()) != null && now - oldest.getTimestamp() > maxAgeMs) {
            this.footsteps.removeLast();
        }
    }

    private void removeBySteps(int maxSteps) {
        while (this.footsteps.size() > maxSteps) {
            this.footsteps.removeLast();
        }
    }

    public Iterator<Footstep> getFootsteps() {
        return this.footsteps.iterator();
    }

    public int getCount() {
        return this.footsteps.size();
    }

    public void clear() {
        this.footsteps.clear();
        this.lastX = Double.NaN;
        this.lastY = Double.NaN;
        this.lastZ = Double.NaN;
    }
}

