/*
 * Decompiled with CFR 0.152.
 */
package dev.footstepstrail.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.footstepstrail.config.FootprintPlacementMode;
import dev.footstepstrail.config.FootstepsConfig;
import dev.footstepstrail.config.TrackingMode;
import dev.footstepstrail.tracking.FootstepsTracker;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class FootstepsCommand {
    private static final String[] COLOR_OPTIONS = new String[]{"white", "gray", "red", "green", "blue", "yellow"};

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"footsteps").executes(context -> FootstepsCommand.executeStatus((FabricClientCommandSource)context.getSource()))).then(ClientCommandManager.literal((String)"toggle").executes(context -> FootstepsCommand.executeToggle((FabricClientCommandSource)context.getSource())))).then(ClientCommandManager.literal((String)"mode").then(ClientCommandManager.argument((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            builder.suggest("time");
            builder.suggest("steps");
            return builder.buildFuture();
        }).executes(context -> FootstepsCommand.executeMode((FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"mode")))))).then(ClientCommandManager.literal((String)"placement").then(ClientCommandManager.argument((String)"placement", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            builder.suggest("ground");
            builder.suggest("continuous");
            return builder.buildFuture();
        }).executes(context -> FootstepsCommand.executePlacement((FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"placement")))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"config").then(ClientCommandManager.literal((String)"time").then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1, (int)300)).executes(context -> FootstepsCommand.executeDuration((FabricClientCommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"seconds"))))))).then(ClientCommandManager.literal((String)"steps").then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)500)).executes(context -> FootstepsCommand.executeSteps((FabricClientCommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"count")))))))).then(ClientCommandManager.literal((String)"color").then(ClientCommandManager.argument((String)"color", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (String option : COLOR_OPTIONS) {
                builder.suggest(option);
            }
            return builder.buildFuture();
        }).executes(context -> FootstepsCommand.executeColor((FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"color")))))).then(ClientCommandManager.literal((String)"size").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.05f, (float)2.0f)).executes(context -> FootstepsCommand.executeSize((FabricClientCommandSource)context.getSource(), FloatArgumentType.getFloat((CommandContext)context, (String)"value")))))).then(ClientCommandManager.literal((String)"clear").executes(context -> FootstepsCommand.executeClear((FabricClientCommandSource)context.getSource())))).then(ClientCommandManager.literal((String)"status").executes(context -> FootstepsCommand.executeStatus((FabricClientCommandSource)context.getSource()))));
    }

    private static int executeToggle(FabricClientCommandSource source) {
        FootstepsConfig config = FootstepsConfig.getInstance();
        config.toggle();
        config.save();
        String status = config.isEnabled() ? "enabled" : "disabled";
        class_124 color = config.isEnabled() ? class_124.field_1060 : class_124.field_1061;
        source.sendFeedback((class_2561)class_2561.method_43469((String)"text.footstepstrail.command.toggle", (Object[])new Object[]{class_2561.method_43470((String)status).method_27692(color)}));
        if (!config.isEnabled()) {
            FootstepsTracker.getInstance().clear();
        }
        return 1;
    }

    private static int executeMode(FabricClientCommandSource source, String modeStr) {
        TrackingMode mode;
        FootstepsConfig config = FootstepsConfig.getInstance();
        try {
            mode = TrackingMode.valueOf(modeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            source.sendError((class_2561)class_2561.method_43471((String)"text.footstepstrail.command.invalid_mode").method_27692(class_124.field_1061));
            return 0;
        }
        config.setTrackingMode(mode);
        config.save();
        FootstepsTracker.getInstance().clear();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"text.footstepstrail.command.mode", (Object[])new Object[]{class_2561.method_43470((String)mode.name().toLowerCase()).method_27692(class_124.field_1075)}));
        return 1;
    }

    private static int executePlacement(FabricClientCommandSource source, String placementStr) {
        FootprintPlacementMode placementMode;
        String normalized;
        FootstepsConfig config = FootstepsConfig.getInstance();
        switch (normalized = placementStr.toLowerCase()) {
            case "ground": 
            case "ground_only": 
            case "groundonly": {
                placementMode = FootprintPlacementMode.GROUND_ONLY;
                break;
            }
            case "continuous": 
            case "legacy": 
            case "classic": {
                placementMode = FootprintPlacementMode.CONTINUOUS;
                break;
            }
            default: {
                source.sendError((class_2561)class_2561.method_43471((String)"text.footstepstrail.command.invalid_placement").method_27692(class_124.field_1061));
                return 0;
            }
        }
        config.setPlacementMode(placementMode);
        config.save();
        FootstepsTracker.getInstance().clear();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"text.footstepstrail.command.placement", (Object[])new Object[]{class_2561.method_43470((String)placementMode.name().toLowerCase()).method_27692(class_124.field_1075)}));
        return 1;
    }

    private static int executeDuration(FabricClientCommandSource source, int seconds) {
        FootstepsConfig config = FootstepsConfig.getInstance();
        config.setMaxDurationSeconds(seconds);
        config.save();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"text.footstepstrail.command.duration", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(seconds)).method_27692(class_124.field_1075)}));
        return 1;
    }

    private static int executeSteps(FabricClientCommandSource source, int count) {
        FootstepsConfig config = FootstepsConfig.getInstance();
        config.setMaxSteps(count);
        config.save();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"text.footstepstrail.command.steps", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(count)).method_27692(class_124.field_1075)}));
        return 1;
    }

    private static int executeColor(FabricClientCommandSource source, String colorName) {
        String normalized;
        FootstepsConfig config = FootstepsConfig.getInstance();
        switch (normalized = colorName.toLowerCase()) {
            case "white": {
                config.setColor(1.0f, 1.0f, 1.0f);
                break;
            }
            case "gray": 
            case "grey": {
                config.setColor(0.7f, 0.7f, 0.7f);
                normalized = "gray";
                break;
            }
            case "red": {
                config.setColor(1.0f, 0.2f, 0.2f);
                break;
            }
            case "green": {
                config.setColor(0.2f, 1.0f, 0.2f);
                break;
            }
            case "blue": {
                config.setColor(0.2f, 0.4f, 1.0f);
                break;
            }
            case "yellow": {
                config.setColor(1.0f, 1.0f, 0.2f);
                break;
            }
            default: {
                source.sendError((class_2561)class_2561.method_43471((String)"text.footstepstrail.command.invalid_color").method_27692(class_124.field_1061));
                return 0;
            }
        }
        config.save();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"text.footstepstrail.command.color", (Object[])new Object[]{class_2561.method_43470((String)normalized).method_27692(class_124.field_1075)}).method_27692(class_124.field_1060));
        return 1;
    }

    private static int executeSize(FabricClientCommandSource source, float value) {
        FootstepsConfig config = FootstepsConfig.getInstance();
        config.setMarkerSize(value);
        config.save();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"text.footstepstrail.command.size", (Object[])new Object[]{class_2561.method_43470((String)String.format("%.2f", Float.valueOf(value))).method_27692(class_124.field_1075)}));
        return 1;
    }

    private static int executeClear(FabricClientCommandSource source) {
        FootstepsTracker.getInstance().clear();
        source.sendFeedback((class_2561)class_2561.method_43471((String)"text.footstepstrail.command.clear").method_27692(class_124.field_1054));
        return 1;
    }

    private static int executeStatus(FabricClientCommandSource source) {
        FootstepsConfig config = FootstepsConfig.getInstance();
        FootstepsTracker tracker = FootstepsTracker.getInstance();
        String enabledStr = config.isEnabled() ? "Enabled" : "Disabled";
        class_124 enabledColor = config.isEnabled() ? class_124.field_1060 : class_124.field_1061;
        source.sendFeedback((class_2561)class_2561.method_43471((String)"text.footstepstrail.status.title").method_27692(class_124.field_1065));
        source.sendFeedback((class_2561)class_2561.method_43469((String)"text.footstepstrail.status.status", (Object[])new Object[]{class_2561.method_43470((String)enabledStr).method_27692(enabledColor)}));
        source.sendFeedback((class_2561)class_2561.method_43469((String)"text.footstepstrail.status.mode", (Object[])new Object[]{class_2561.method_43470((String)config.getTrackingMode().name().toLowerCase()).method_27692(class_124.field_1075)}));
        source.sendFeedback((class_2561)class_2561.method_43469((String)"text.footstepstrail.status.placement", (Object[])new Object[]{class_2561.method_43470((String)config.getPlacementMode().name().toLowerCase()).method_27692(class_124.field_1075)}));
        if (config.getTrackingMode() == TrackingMode.TIME) {
            source.sendFeedback((class_2561)class_2561.method_43469((String)"text.footstepstrail.status.duration", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(config.getMaxDurationSeconds())).method_27692(class_124.field_1075)}));
        } else {
            source.sendFeedback((class_2561)class_2561.method_43469((String)"text.footstepstrail.status.steps", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(config.getMaxSteps())).method_27692(class_124.field_1075)}));
        }
        source.sendFeedback((class_2561)class_2561.method_43469((String)"text.footstepstrail.status.color", (Object[])new Object[]{(int)(config.getColorR() * 255.0f), (int)(config.getColorG() * 255.0f), (int)(config.getColorB() * 255.0f)}).method_27692(class_124.field_1075));
        source.sendFeedback((class_2561)class_2561.method_43469((String)"text.footstepstrail.status.size", (Object[])new Object[]{Float.valueOf(config.getMarkerSize())}).method_27692(class_124.field_1075));
        source.sendFeedback((class_2561)class_2561.method_43469((String)"text.footstepstrail.status.opacity", (Object[])new Object[]{Float.valueOf(config.getMaxOpacity())}).method_27692(class_124.field_1075));
        source.sendFeedback((class_2561)class_2561.method_43469((String)"text.footstepstrail.status.active", (Object[])new Object[]{tracker.getCount()}).method_27692(class_124.field_1054));
        return 1;
    }
}

