/*
 * Decompiled with CFR 0.152.
 */
package dev.footstepstrail.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.footstepstrail.config.FootprintPlacementMode;
import dev.footstepstrail.config.TrackingMode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class FootstepsConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("footstepstrail.json");
    private static FootstepsConfig INSTANCE;
    private boolean enabled = true;
    private TrackingMode trackingMode = TrackingMode.STEPS;
    private FootprintPlacementMode placementMode = FootprintPlacementMode.GROUND_ONLY;
    private int maxDurationSeconds = 30;
    private int maxSteps = 50;
    private double minDistanceForStep = 1.0;
    private float markerSize = 0.2f;
    private float colorR = 0.7f;
    private float colorG = 0.7f;
    private float colorB = 0.7f;
    private float maxOpacity = 0.6f;

    private FootstepsConfig() {
    }

    public static FootstepsConfig getInstance() {
        if (INSTANCE == null) {
            FootstepsConfig.load();
        }
        return INSTANCE;
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                INSTANCE = (FootstepsConfig)GSON.fromJson((Reader)reader, FootstepsConfig.class);
                if (INSTANCE != null) {
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        INSTANCE = new FootstepsConfig();
        INSTANCE.save();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void toggle() {
        this.enabled = !this.enabled;
    }

    public TrackingMode getTrackingMode() {
        return this.trackingMode;
    }

    public void setTrackingMode(TrackingMode trackingMode) {
        this.trackingMode = trackingMode;
    }

    public FootprintPlacementMode getPlacementMode() {
        return this.placementMode;
    }

    public void setPlacementMode(FootprintPlacementMode placementMode) {
        if (placementMode == null) {
            return;
        }
        this.placementMode = placementMode;
    }

    public int getMaxDurationSeconds() {
        return this.maxDurationSeconds;
    }

    public void setMaxDurationSeconds(int maxDurationSeconds) {
        this.maxDurationSeconds = Math.max(1, Math.min(300, maxDurationSeconds));
    }

    public int getMaxSteps() {
        return this.maxSteps;
    }

    public void setMaxSteps(int maxSteps) {
        this.maxSteps = Math.max(1, Math.min(500, maxSteps));
    }

    public double getMinDistanceForStep() {
        return this.minDistanceForStep;
    }

    public void setMinDistanceForStep(double minDistanceForStep) {
        this.minDistanceForStep = Math.max(0.1, Math.min(5.0, minDistanceForStep));
    }

    public float getMarkerSize() {
        return this.markerSize;
    }

    public void setMarkerSize(float markerSize) {
        this.markerSize = Math.max(0.05f, Math.min(2.0f, markerSize));
    }

    public float getColorR() {
        return this.colorR;
    }

    public float getColorG() {
        return this.colorG;
    }

    public float getColorB() {
        return this.colorB;
    }

    public void setColor(float r, float g, float b) {
        this.colorR = Math.max(0.0f, Math.min(1.0f, r));
        this.colorG = Math.max(0.0f, Math.min(1.0f, g));
        this.colorB = Math.max(0.0f, Math.min(1.0f, b));
    }

    public float getMaxOpacity() {
        return this.maxOpacity;
    }

    public void setMaxOpacity(float maxOpacity) {
        this.maxOpacity = Math.max(0.05f, Math.min(1.0f, maxOpacity));
    }
}

