/*
 * Decompiled with CFR 0.152.
 */
package dev.footstepstrail.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.footstepstrail.config.FootstepsConfig;
import dev.footstepstrail.config.TrackingMode;
import dev.footstepstrail.tracking.Footstep;
import dev.footstepstrail.tracking.FootstepsTracker;
import java.util.Iterator;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class FootstepsRenderer {
    private static FootstepsRenderer INSTANCE;
    private static final float HEIGHT_OFFSET = 0.02f;

    private FootstepsRenderer() {
    }

    public static FootstepsRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FootstepsRenderer();
        }
        return INSTANCE;
    }

    public void render(WorldRenderContext context) {
        FootstepsConfig config = FootstepsConfig.getInstance();
        if (!config.isEnabled()) {
            return;
        }
        FootstepsTracker tracker = FootstepsTracker.getInstance();
        int totalFootsteps = tracker.getCount();
        if (totalFootsteps == 0) {
            return;
        }
        class_4184 camera = context.camera();
        double camX = camera.method_19326().field_1352;
        double camY = camera.method_19326().field_1351;
        double camZ = camera.method_19326().field_1350;
        class_4587 matrices = context.matrixStack();
        matrices.method_22903();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        long now = System.currentTimeMillis();
        int maxDurationMs = config.getMaxDurationSeconds() * 1000;
        float markerHalfSize = config.getMarkerSize();
        float maxOpacity = config.getMaxOpacity();
        int r = (int)(config.getColorR() * 255.0f);
        int g = (int)(config.getColorG() * 255.0f);
        int b = (int)(config.getColorB() * 255.0f);
        Iterator<Footstep> iterator = tracker.getFootsteps();
        int index = 0;
        while (iterator.hasNext()) {
            float opacity;
            Footstep footstep = iterator.next();
            if (config.getTrackingMode() == TrackingMode.TIME) {
                long age = now - footstep.getTimestamp();
                float normalizedAge = (float)age / (float)maxDurationMs;
                normalizedAge = Math.min(1.0f, Math.max(0.0f, normalizedAge));
                opacity = (1.0f - normalizedAge) * maxOpacity;
            } else {
                float normalizedIndex = (float)index / (float)totalFootsteps;
                opacity = (1.0f - normalizedIndex) * maxOpacity;
            }
            ++index;
            if (opacity < 0.01f) continue;
            float x = (float)(footstep.getX() - camX);
            float y = (float)(footstep.getY() - camY + (double)0.02f);
            float z = (float)(footstep.getZ() - camZ);
            Matrix4f matrix = matrices.method_23760().method_23761();
            int a = (int)(opacity * 255.0f);
            buffer.method_22918(matrix, x - markerHalfSize, y, z - markerHalfSize).method_1336(r, g, b, a).method_1344();
            buffer.method_22918(matrix, x - markerHalfSize, y, z + markerHalfSize).method_1336(r, g, b, a).method_1344();
            buffer.method_22918(matrix, x + markerHalfSize, y, z + markerHalfSize).method_1336(r, g, b, a).method_1344();
            buffer.method_22918(matrix, x + markerHalfSize, y, z - markerHalfSize).method_1336(r, g, b, a).method_1344();
        }
        tessellator.method_1350();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        matrices.method_22909();
    }
}

