/*
 * Decompiled with CFR 0.152.
 */
package dev.footstepstrail.tracking;

import dev.footstepstrail.config.FootprintPlacementMode;
import dev.footstepstrail.config.FootstepsConfig;
import dev.footstepstrail.config.TrackingMode;
import dev.footstepstrail.tracking.Footstep;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import net.minecraft.class_1297;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class FootstepsTracker {
    private static FootstepsTracker INSTANCE;
    private final Deque<Footstep> footsteps = new ArrayDeque<Footstep>();
    private int stepCounter = 0;
    private double lastX = Double.NaN;
    private double lastY = Double.NaN;
    private double lastZ = Double.NaN;

    private FootstepsTracker() {
    }

    public static FootstepsTracker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FootstepsTracker();
        }
        return INSTANCE;
    }

    public void tick() {
        FootstepsConfig config = FootstepsConfig.getInstance();
        if (!config.isEnabled()) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null || client.field_1687 == null) {
            return;
        }
        class_243 candidate = this.getCandidateFootstepPos(player, client.field_1687, config);
        if (candidate != null && this.shouldRecordFootstep(candidate.field_1352, candidate.field_1351, candidate.field_1350, config)) {
            this.recordFootstep(candidate.field_1352, candidate.field_1351, candidate.field_1350);
        }
        this.removeExpiredFootsteps(config);
    }

    private class_243 getCandidateFootstepPos(class_746 player, class_638 world, FootstepsConfig config) {
        class_243 end;
        FootprintPlacementMode placementMode = config.getPlacementMode();
        if (placementMode == FootprintPlacementMode.CONTINUOUS) {
            return new class_243(player.method_23317(), player.method_23318(), player.method_23321());
        }
        if (!player.method_24828()) {
            return null;
        }
        if (player.method_5799() || player.method_5869() || player.method_5771()) {
            return null;
        }
        class_243 start = player.method_19538().method_1031(0.0, 0.1, 0.0);
        class_3965 hit = world.method_17742(new class_3959(start, end = start.method_1031(0.0, -2.0, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        if (hit.method_17783() != class_239.class_240.field_1332) {
            return null;
        }
        class_243 hitPos = hit.method_17784();
        return new class_243(hitPos.field_1352, hitPos.field_1351, hitPos.field_1350);
    }

    private boolean shouldRecordFootstep(double x, double y, double z, FootstepsConfig config) {
        if (Double.isNaN(this.lastX)) {
            return true;
        }
        double dx = x - this.lastX;
        double dy = y - this.lastY;
        double dz = z - this.lastZ;
        double distSquared = dx * dx + dy * dy + dz * dz;
        double minDist = config.getMinDistanceForStep();
        double minDistSquared = minDist * minDist;
        return distSquared >= minDistSquared;
    }

    private void recordFootstep(double x, double y, double z) {
        long now = System.currentTimeMillis();
        Footstep footstep = new Footstep(x, y, z, now, this.stepCounter++);
        this.footsteps.addFirst(footstep);
        this.lastX = x;
        this.lastY = y;
        this.lastZ = z;
    }

    private void removeExpiredFootsteps(FootstepsConfig config) {
        if (config.getTrackingMode() == TrackingMode.TIME) {
            this.removeByTime(config.getMaxDurationSeconds());
        } else {
            this.removeBySteps(config.getMaxSteps());
        }
    }

    private void removeByTime(int maxDurationSeconds) {
        Footstep oldest;
        long now = System.currentTimeMillis();
        long maxAgeMs = (long)maxDurationSeconds * 1000L;
        while (!this.footsteps.isEmpty() && (oldest = this.footsteps.peekLast()) != null && now - oldest.getTimestamp() > maxAgeMs) {
            this.footsteps.removeLast();
        }
    }

    private void removeBySteps(int maxSteps) {
        while (this.footsteps.size() > maxSteps) {
            this.footsteps.removeLast();
        }
    }

    public Iterator<Footstep> getFootsteps() {
        return this.footsteps.iterator();
    }

    public int getCount() {
        return this.footsteps.size();
    }

    public void clear() {
        this.footsteps.clear();
        this.lastX = Double.NaN;
        this.lastY = Double.NaN;
        this.lastZ = Double.NaN;
    }
}

