/*
 * Decompiled with CFR 0.152.
 */
package org.yanbwe.raritycore;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.yanbwe.raritycore.command.RarityCoreCommands;
import org.yanbwe.raritycore.config.ConfigManager;
import org.yanbwe.raritycore.data.RarityDataLoader;
import org.yanbwe.raritycore.network.IncrementalSyncPacket;
import org.yanbwe.raritycore.network.RaritySyncPacket;
import org.yanbwe.raritycore.registry.RarityRegistry;

@Mod(value="raritycore")
public class RarityCore {
    public static final String MODID = "raritycore";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static ScheduledExecutorService syncScheduler;

    public RarityCore() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ConfigManager.initializeConfigs();
    }

    @SubscribeEvent
    public void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)RarityDataLoader.INSTANCE);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(RaritySyncPacket::initialize);
        event.enqueueWork(IncrementalSyncPacket::initialize);
        event.enqueueWork(ConfigManager::initializeConfigs);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        syncScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "RarityCore-Incremental-Sync");
            t.setDaemon(true);
            return t;
        });
        syncScheduler.scheduleAtFixedRate(() -> {
            try {
                if (RarityRegistry.getPendingChangeCount() > 0) {
                    RarityRegistry.syncIncrementalChangesToClients();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error during incremental sync", (Throwable)e);
            }
        }, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent event) {
        if (syncScheduler != null) {
            syncScheduler.shutdown();
            try {
                if (!syncScheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    syncScheduler.shutdownNow();
                    if (!syncScheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                        LOGGER.error("Pool did not terminate cleanly");
                    }
                }
            }
            catch (InterruptedException e) {
                syncScheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
            syncScheduler = null;
        }
        RarityRegistry.clearChangeBuffer();
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        RarityCoreCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            HashMap<ResourceLocation, Integer> currentData = new HashMap<ResourceLocation, Integer>(RarityRegistry.ITEM_RARITY_MAP);
            RaritySyncPacket packet = new RaritySyncPacket(currentData);
            RaritySyncPacket.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)packet);
        }
    }
}

