/*
 * Decompiled with CFR 0.152.
 */
package org.yanbwe.raritycore.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.yanbwe.raritycore.RarityCore;
import org.yanbwe.raritycore.config.ConfigManager;
import org.yanbwe.raritycore.registry.RarityRegistry;
import org.yanbwe.raritycore.util.RarityColorUtil;

public class ItemBorderRenderer {
    public static void renderRarityBorder(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y) {
        if (!ConfigManager.isEnableItemBorderRendering()) {
            return;
        }
        if (itemStack.m_41619_()) {
            return;
        }
        Item item = itemStack.m_41720_();
        Integer rarity = RarityRegistry.getRarity(item);
        if (rarity == null) {
            rarity = 1;
        }
        if (rarity < 1) {
            rarity = 1;
        } else if (rarity > 7) {
            rarity = 7;
        }
        if (ConfigManager.isEnableItemBackgroundRendering()) {
            ItemBorderRenderer.renderItemBackground(guiGraphics, rarity, x, y);
        }
        if (ConfigManager.isUseTextureBorder()) {
            ItemBorderRenderer.renderTextureBorder(guiGraphics, rarity, x, y);
        } else {
            ItemBorderRenderer.renderColorBorder(guiGraphics, rarity, x, y);
        }
    }

    private static void renderTextureBorder(GuiGraphics guiGraphics, int rarity, int x, int y) {
        String textureName = "rarity_" + rarity;
        ResourceLocation textureLocation = new ResourceLocation("raritycore:textures/border/" + textureName + ".png");
        try {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.m_280163_(textureLocation, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        catch (Exception e) {
            RarityCore.LOGGER.warn("Failed to load texture for rarity {}, falling back to color border: {}", (Object)rarity, (Object)e.getMessage());
            ItemBorderRenderer.renderColorBorder(guiGraphics, rarity, x, y);
        }
    }

    private static void renderItemBackground(GuiGraphics guiGraphics, int rarity, int x, int y) {
        int backgroundColor = RarityColorUtil.getRarityArgbColor(rarity);
        int alphaMask = ConfigManager.isUseTextureBorder() ? 0x40000000 : 0x60000000;
        int translucentBackgroundColor = backgroundColor & 0xFFFFFF | alphaMask;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280509_(x, y, x + 16, y + 16, translucentBackgroundColor);
    }

    private static void renderColorBorder(GuiGraphics guiGraphics, int rarity, int x, int y) {
        int borderColor = RarityColorUtil.getRarityArgbColor(rarity);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (ConfigManager.getItemBorderStyle() == 1) {
            int alphaMask = Integer.MIN_VALUE;
            int translucentColor = borderColor & 0xFFFFFF | alphaMask;
            guiGraphics.m_280509_(x, y, x + 16, y + 16, translucentColor);
        } else {
            guiGraphics.m_280509_(x, y, x + 16, y + 1, borderColor);
            guiGraphics.m_280509_(x, y + 15, x + 16, y + 16, borderColor);
            guiGraphics.m_280509_(x, y, x + 1, y + 16, borderColor);
            guiGraphics.m_280509_(x + 15, y, x + 16, y + 16, borderColor);
        }
    }

    private static int getRarityColor(int rarity) {
        return RarityColorUtil.getRarityArgbColor(rarity);
    }
}

