/*
 * Decompiled with CFR 0.152.
 */
package org.yanbwe.raritycore.client;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.yanbwe.raritycore.config.ConfigManager;
import org.yanbwe.raritycore.registry.RarityRegistry;
import org.yanbwe.raritycore.util.RarityColorUtil;

@Mod.EventBusSubscriber(modid="raritycore", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class RarityTooltipHandler {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        MutableComponent prefixComponent;
        if (!ConfigManager.isEnableTooltipInsert()) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.m_41720_();
        Integer rarity = RarityRegistry.getRarity(item);
        if (rarity == null) {
            rarity = 1;
        }
        ChatFormatting color = RarityColorUtil.getRarityChatColor(rarity);
        if (rarity > 7) {
            ChatFormatting uniqueColor = RarityColorUtil.getRarityChatColor(7);
            StringBuilder stars = new StringBuilder();
            for (int i = 0; i < rarity; ++i) {
                stars.append("\u2b50");
            }
            MutableComponent numberComponent = Component.m_237113_((String)("[" + rarity)).m_130940_(uniqueColor);
            MutableComponent tipsComponent = Component.m_237115_((String)"rarity.core.unusual.tips").m_130940_(uniqueColor);
            MutableComponent starsComponent = Component.m_237113_((String)(stars.toString() + "]")).m_130940_(uniqueColor);
            MutableComponent rarityComponent = Component.m_237119_().m_7220_((Component)numberComponent).m_7220_((Component)tipsComponent).m_7220_((Component)starsComponent);
            if (!event.getToolTip().isEmpty()) {
                event.getToolTip().add(1, rarityComponent);
            } else {
                event.getToolTip().add(rarityComponent);
            }
            return;
        }
        if (rarity < 1) {
            rarity = 1;
        }
        switch (rarity) {
            case 1: {
                prefixComponent = Component.m_237115_((String)"rarity.core.common").m_130940_(color);
                break;
            }
            case 2: {
                prefixComponent = Component.m_237115_((String)"rarity.core.uncommon").m_130940_(color);
                break;
            }
            case 3: {
                prefixComponent = Component.m_237115_((String)"rarity.core.rare").m_130940_(color);
                break;
            }
            case 4: {
                prefixComponent = Component.m_237115_((String)"rarity.core.epic").m_130940_(color);
                break;
            }
            case 5: {
                prefixComponent = Component.m_237115_((String)"rarity.core.legendary").m_130940_(color);
                break;
            }
            case 6: {
                prefixComponent = Component.m_237115_((String)"rarity.core.mythical").m_130940_(color);
                break;
            }
            case 7: {
                prefixComponent = Component.m_237115_((String)"rarity.core.unique").m_130940_(color);
                break;
            }
            default: {
                return;
            }
        }
        StringBuilder stars = new StringBuilder();
        for (int i = 0; i < rarity; ++i) {
            stars.append("\u2b50");
        }
        MutableComponent starsComponent = Component.m_237113_((String)(" " + stars)).m_130940_(color);
        MutableComponent rarityComponent = Component.m_237119_().m_7220_((Component)prefixComponent).m_7220_((Component)starsComponent);
        if (!event.getToolTip().isEmpty()) {
            event.getToolTip().add(1, rarityComponent);
        } else {
            event.getToolTip().add(rarityComponent);
        }
    }
}

