/*
 * Decompiled with CFR 0.152.
 */
package org.yanbwe.raritycore.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.yanbwe.raritycore.RarityCore;
import org.yanbwe.raritycore.config.ConfigManager;
import org.yanbwe.raritycore.config.RarityConfigLoader;
import org.yanbwe.raritycore.registry.RarityRegistry;

public class RarityCoreCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"raritycore").then(Commands.m_82127_((String)"sethand").then(Commands.m_82129_((String)"rarity", (ArgumentType)IntegerArgumentType.integer()).executes(context -> RarityCoreCommands.setHandRarity((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"rarity")))))).then(Commands.m_82127_((String)"setrarity").then(Commands.m_82129_((String)"item", (ArgumentType)ResourceLocationArgument.m_106984_()).then(Commands.m_82129_((String)"rarity", (ArgumentType)IntegerArgumentType.integer()).executes(context -> RarityCoreCommands.setItemRarity((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"item"), IntegerArgumentType.getInteger((CommandContext)context, (String)"rarity"))))))).then(Commands.m_82127_((String)"reload").executes(context -> RarityCoreCommands.reloadRarityData((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"export").then(Commands.m_82127_((String)"all").executes(context -> RarityCoreCommands.exportAllRarityData((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"all-mod").executes(context -> RarityCoreCommands.exportAllModRarityData((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"mod").then(Commands.m_82129_((String)"modid", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(context -> RarityCoreCommands.exportModRarityData((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"modid"))))))).then(Commands.m_82127_((String)"details").executes(context -> RarityCoreCommands.showDetails((CommandSourceStack)context.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"raritycore-client").executes(context -> RarityCoreCommands.reloadClientConfig((CommandSourceStack)context.getSource())));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"raritycore-texture").then(Commands.m_82127_((String)"toggle").executes(context -> RarityCoreCommands.toggleTextureBorder((CommandSourceStack)context.getSource()))));
    }

    private static int setHandRarity(CommandSourceStack source, int rarity) {
        try {
            ServerPlayer player = source.m_81375_();
            ItemStack itemStack = player.m_21205_();
            if (itemStack.m_41619_()) {
                source.m_288197_(() -> Component.m_237115_((String)"rarity.core.no_item_in_hand").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
            Item item = itemStack.m_41720_();
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item);
            if (itemId == null || itemId.equals((Object)ForgeRegistries.ITEMS.getDefaultKey())) {
                source.m_288197_(() -> Component.m_237115_((String)"rarity.core.unrecognized_item").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
            RarityRegistry.register(item, rarity, false);
            RarityCoreCommands.saveRarityToConfig(itemId.toString(), rarity);
            RarityRegistry.syncRarityToClients();
            source.m_288197_(() -> Component.m_237110_((String)"rarity.core.item_set_rarity", (Object[])new Object[]{itemId, rarity}).m_130940_(ChatFormatting.GREEN), false);
            return 1;
        }
        catch (CommandSyntaxException e) {
            RarityCore.LOGGER.error("Command execution failed", (Throwable)e);
            source.m_288197_(() -> Component.m_237115_((String)"rarity.core.command_failed").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
    }

    private static int setItemRarity(CommandSourceStack source, ResourceLocation itemId, int rarity) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
        if (item == null || itemId.equals((Object)ForgeRegistries.ITEMS.getDefaultKey())) {
            source.m_288197_(() -> Component.m_237110_((String)"rarity.core.unknown_item_id", (Object[])new Object[]{itemId}).m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        RarityRegistry.register(item, rarity, false);
        RarityCoreCommands.saveRarityToConfig(itemId.toString(), rarity);
        RarityRegistry.syncRarityToClients();
        source.m_288197_(() -> Component.m_237110_((String)"rarity.core.item_set_rarity_by_id", (Object[])new Object[]{itemId, rarity}).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int reloadRarityData(CommandSourceStack source) {
        RarityConfigLoader.loadConfigRarityData();
        RarityRegistry.syncRarityToClients();
        source.m_288197_(() -> Component.m_237115_((String)"rarity.core.reload_success").m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int showDetails(CommandSourceStack source) {
        HashMap<String, Integer> modItemCount = new HashMap<String, Integer>();
        int totalItems = 0;
        for (Map.Entry<ResourceLocation, Integer> entry : RarityRegistry.ITEM_RARITY_MAP.entrySet()) {
            String modId = entry.getKey().m_135827_();
            modItemCount.put(modId, modItemCount.getOrDefault(modId, 0) + 1);
            ++totalItems;
        }
        int modCount = modItemCount.size();
        StringBuilder response = new StringBuilder();
        response.append(Component.m_237110_((String)"rarity.core.mods_count", (Object[])new Object[]{modCount}).getString()).append("\n");
        response.append(Component.m_237110_((String)"rarity.core.items_count", (Object[])new Object[]{totalItems}).getString()).append("\n");
        for (Map.Entry entry : modItemCount.entrySet()) {
            response.append((String)entry.getKey()).append(":").append(entry.getValue()).append(" ");
        }
        source.m_288197_(() -> Component.m_237113_((String)response.toString().trim()).m_130940_(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static int exportAllRarityData(CommandSourceStack source) {
        try {
            Path configDir = ConfigManager.getConfigDirPath();
            Files.createDirectories(configDir, new FileAttribute[0]);
            String mcVersion = "1.20.1";
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss"));
            String fileName = "export_all_" + mcVersion + "_" + timestamp + ".json";
            Path exportFile = configDir.resolve(fileName);
            RarityCoreCommands.exportRarityDataToFile(exportFile);
            source.m_288197_(() -> Component.m_237110_((String)"rarity.core.export_all_success", (Object[])new Object[]{exportFile.toString()}).m_130940_(ChatFormatting.GREEN), false);
            return 1;
        }
        catch (IOException e) {
            RarityCore.LOGGER.error("Failed to export rarity data", (Throwable)e);
            source.m_288197_(() -> Component.m_237110_((String)"rarity.core.export_failed", (Object[])new Object[]{e.getMessage()}).m_130940_(ChatFormatting.RED), false);
            return 0;
        }
    }

    private static int exportModRarityData(CommandSourceStack source, ResourceLocation modId) {
        try {
            Path configDir = ConfigManager.getConfigDirPath();
            Files.createDirectories(configDir, new FileAttribute[0]);
            String mcVersion = "1.20.1";
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss"));
            String fileName = "export_mod_" + modId.m_135827_() + "_" + mcVersion + "_" + timestamp + ".json";
            Path exportFile = configDir.resolve(fileName);
            RarityCoreCommands.exportModRarityDataToFile(exportFile, modId.m_135827_());
            source.m_288197_(() -> Component.m_237110_((String)"rarity.core.export_mod_success", (Object[])new Object[]{modId.m_135827_(), exportFile.toString()}).m_130940_(ChatFormatting.GREEN), false);
            return 1;
        }
        catch (IOException e) {
            RarityCore.LOGGER.error("Failed to export mod rarity data", (Throwable)e);
            source.m_288197_(() -> Component.m_237110_((String)"rarity.core.export_mod_failed", (Object[])new Object[]{e.getMessage()}).m_130940_(ChatFormatting.RED), false);
            return 0;
        }
    }

    private static int exportAllModRarityData(CommandSourceStack source) {
        try {
            Path configDir = ConfigManager.getConfigDirPath();
            Files.createDirectories(configDir, new FileAttribute[0]);
            String mcVersion = "1.20.1";
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss"));
            Path exportDir = configDir.resolve("export_all-mod_" + mcVersion + "_" + timestamp);
            Files.createDirectories(exportDir, new FileAttribute[0]);
            HashMap<String, Map> modBasedData = new HashMap<String, Map>();
            for (Map.Entry<ResourceLocation, Integer> entry : RarityRegistry.ITEM_RARITY_MAP.entrySet()) {
                String modId = entry.getKey().m_135827_();
                String itemId = entry.getKey().toString();
                Integer rarity = entry.getValue();
                modBasedData.computeIfAbsent(modId, k -> new HashMap()).put(itemId, rarity);
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            for (Map.Entry modEntry : modBasedData.entrySet()) {
                String modId = (String)modEntry.getKey();
                Map modData = (Map)modEntry.getValue();
                Path modExportFile = exportDir.resolve(modId + "_" + mcVersion + ".json");
                try (FileWriter writer = new FileWriter(modExportFile.toFile());){
                    gson.toJson((Object)modData, (Appendable)writer);
                }
            }
            source.m_288197_(() -> Component.m_237110_((String)"rarity.core.export_all_success", (Object[])new Object[]{exportDir.toString()}).m_130940_(ChatFormatting.GREEN), false);
            return 1;
        }
        catch (IOException e) {
            RarityCore.LOGGER.error("Failed to export all-mod rarity data", (Throwable)e);
            source.m_288197_(() -> Component.m_237110_((String)"rarity.core.export_failed", (Object[])new Object[]{e.getMessage()}).m_130940_(ChatFormatting.RED), false);
            return 0;
        }
    }

    private static int reloadClientConfig(CommandSourceStack source) {
        ConfigManager.loadClientConfig();
        String borderStyleText = ConfigManager.getItemBorderStyle() == 0 ? Component.m_237115_((String)"rarity.core.border_style_hollow").getString() : Component.m_237115_((String)"rarity.core.border_style_solid").getString();
        String textureBorderStatus = ConfigManager.isUseTextureBorder() ? Component.m_237115_((String)"rarity.core.enabled").getString() : Component.m_237115_((String)"rarity.core.disabled").getString();
        source.m_288197_(() -> Component.m_237110_((String)"rarity.core.reload_client_config_with_texture", (Object[])new Object[]{ConfigManager.isEnableItemBorderRendering(), borderStyleText, textureBorderStatus}).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int toggleTextureBorder(CommandSourceStack source) {
        boolean currentState = ConfigManager.isUseTextureBorder();
        boolean newState = !currentState;
        ConfigManager.setUseTextureBorder(newState);
        try {
            JsonObject jsonObject;
            Path configDir = ConfigManager.getConfigDirPath();
            Files.createDirectories(configDir, new FileAttribute[0]);
            Path configFile = ConfigManager.getClientConfigPath();
            if (Files.exists(configFile, new LinkOption[0])) {
                String content = Files.readString(configFile);
                if (!content.trim().isEmpty()) {
                    try {
                        jsonObject = JsonParser.parseString((String)content).getAsJsonObject();
                    }
                    catch (Exception e) {
                        RarityCore.LOGGER.warn("\u89e3\u6790\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c\u5c06\u91cd\u65b0\u521b\u5efa", (Throwable)e);
                        jsonObject = new JsonObject();
                    }
                } else {
                    jsonObject = new JsonObject();
                }
            } else {
                jsonObject = new JsonObject();
            }
            jsonObject.addProperty("useTextureBorder", Boolean.valueOf(newState));
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try (FileWriter writer = new FileWriter(configFile.toFile());){
                gson.toJson((JsonElement)jsonObject, (Appendable)writer);
            }
            source.m_288197_(() -> Component.m_237110_((String)"rarity.core.texture_border_toggle_success", (Object[])new Object[]{newState ? Component.m_237115_((String)"rarity.core.enabled") : Component.m_237115_((String)"rarity.core.disabled")}).m_130940_(ChatFormatting.GREEN), false);
            return 1;
        }
        catch (IOException e) {
            RarityCore.LOGGER.error("Failed to save client config", (Throwable)e);
            source.m_288197_(() -> Component.m_237115_((String)"rarity.core.texture_border_toggle_error").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
    }

    private static void saveRarityToConfig(String itemId, int rarity) {
        try {
            JsonObject jsonObject;
            Path configDir = ConfigManager.getConfigDirPath();
            Files.createDirectories(configDir, new FileAttribute[0]);
            Path configFile = ConfigManager.getFinalRarityConfigPath();
            if (Files.exists(configFile, new LinkOption[0])) {
                String content = Files.readString(configFile);
                if (!content.trim().isEmpty()) {
                    try {
                        jsonObject = JsonParser.parseString((String)content).getAsJsonObject();
                    }
                    catch (Exception e) {
                        RarityCore.LOGGER.warn("\u89e3\u6790\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c\u5c06\u91cd\u65b0\u521b\u5efa", (Throwable)e);
                        jsonObject = new JsonObject();
                    }
                } else {
                    jsonObject = new JsonObject();
                }
            } else {
                jsonObject = new JsonObject();
            }
            jsonObject.addProperty(itemId, (Number)rarity);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try (FileWriter writer = new FileWriter(configFile.toFile());){
                gson.toJson((JsonElement)jsonObject, (Appendable)writer);
            }
        }
        catch (IOException e) {
            RarityCore.LOGGER.error("Failed to save rarity config", (Throwable)e);
        }
    }

    private static void exportRarityDataToFile(Path exportFile) throws IOException {
        LinkedHashMap<String, Integer> exportData = new LinkedHashMap<String, Integer>();
        for (Map.Entry<ResourceLocation, Integer> entry : RarityRegistry.ITEM_RARITY_MAP.entrySet()) {
            exportData.put(entry.getKey().toString(), entry.getValue());
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(exportFile.toFile());){
            gson.toJson(exportData, (Appendable)writer);
        }
    }

    private static void exportModRarityDataToFile(Path exportFile, String modNamespace) throws IOException {
        LinkedHashMap<String, Integer> exportData = new LinkedHashMap<String, Integer>();
        for (Map.Entry<ResourceLocation, Integer> entry : RarityRegistry.ITEM_RARITY_MAP.entrySet()) {
            if (!entry.getKey().m_135827_().equals(modNamespace)) continue;
            exportData.put(entry.getKey().toString(), entry.getValue());
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(exportFile.toFile());){
            gson.toJson(exportData, (Appendable)writer);
        }
    }
}

