/*
 * Decompiled with CFR 0.152.
 */
package org.yanbwe.raritycore.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.yanbwe.raritycore.RarityCore;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static boolean enableItemBorderRendering = true;
    private static int itemBorderStyle = 1;
    private static boolean useTextureBorder = true;
    private static boolean enableItemNameColor = true;
    private static boolean enableTooltipInsert = true;
    private static boolean enableItemBackgroundRendering = false;
    private static final Path CONFIG_DIR = Paths.get("config", new String[0]).resolve("raritycore");
    private static final Path CLIENT_CONFIG_FILE = CONFIG_DIR.resolve("client.json");

    public static Path getClientConfigPath() {
        return CLIENT_CONFIG_FILE;
    }

    public static Path getConfigDirPath() {
        return CONFIG_DIR;
    }

    public static Path getFinalRarityConfigPath() {
        return CONFIG_DIR.resolve("FinalRarity.json");
    }

    public static void initializeConfigs() {
        try {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
        }
        catch (Exception e) {
            RarityCore.LOGGER.error("Cannot create config directory: {}", (Object)CONFIG_DIR, (Object)e);
            return;
        }
        ConfigManager.loadClientConfig();
    }

    public static void loadClientConfig() {
        if (!Files.exists(CLIENT_CONFIG_FILE, new LinkOption[0])) {
            ConfigManager.createDefaultClientConfig();
        }
        ConfigManager.loadClientConfigFromFile();
    }

    private static void loadClientConfigFromFile() {
        try (BufferedReader reader = Files.newBufferedReader(CLIENT_CONFIG_FILE);){
            JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (jsonObject != null) {
                enableItemBorderRendering = jsonObject.has("enableItemBorderRendering") ? jsonObject.get("enableItemBorderRendering").getAsBoolean() : true;
                if (jsonObject.has("itemBorderStyle")) {
                    itemBorderStyle = jsonObject.get("itemBorderStyle").getAsInt();
                    if (itemBorderStyle < 0 || itemBorderStyle > 1) {
                        itemBorderStyle = 1;
                        RarityCore.LOGGER.warn("Invalid border style value in client config, reset to default: {}", (Object)itemBorderStyle);
                    }
                } else {
                    itemBorderStyle = 1;
                }
                useTextureBorder = jsonObject.has("useTextureBorder") ? jsonObject.get("useTextureBorder").getAsBoolean() : true;
                enableItemNameColor = jsonObject.has("enableItemNameColor") ? jsonObject.get("enableItemNameColor").getAsBoolean() : true;
                enableTooltipInsert = jsonObject.has("enableTooltipInsert") ? jsonObject.get("enableTooltipInsert").getAsBoolean() : true;
                enableItemBackgroundRendering = jsonObject.has("enableItemBackgroundRendering") ? jsonObject.get("enableItemBackgroundRendering").getAsBoolean() : false;
                RarityCore.LOGGER.info("Client config loaded successfully: enableItemBorderRendering={}, itemBorderStyle={}, useTextureBorder={}, enableItemNameColor={}, enableTooltipInsert={}, enableItemBackgroundRendering={}", new Object[]{enableItemBorderRendering, itemBorderStyle, useTextureBorder, enableItemNameColor, enableTooltipInsert, enableItemBackgroundRendering});
            }
        }
        catch (Exception e) {
            RarityCore.LOGGER.error("Error loading client config file, using default config: {}", (Object)CLIENT_CONFIG_FILE, (Object)e);
            enableItemBorderRendering = true;
            itemBorderStyle = 1;
            ConfigManager.createDefaultClientConfig();
        }
    }

    private static void createDefaultClientConfig() {
        JsonObject configObject = new JsonObject();
        configObject.addProperty("enableItemBorderRendering", Boolean.valueOf(true));
        configObject.addProperty("itemBorderStyle", (Number)1);
        configObject.addProperty("useTextureBorder", Boolean.valueOf(true));
        configObject.addProperty("enableItemNameColor", Boolean.valueOf(true));
        configObject.addProperty("enableTooltipInsert", Boolean.valueOf(true));
        configObject.addProperty("enableItemBackgroundRendering", Boolean.valueOf(false));
        try (FileWriter writer = new FileWriter(CLIENT_CONFIG_FILE.toString());){
            GSON.toJson((JsonElement)configObject, (Appendable)writer);
            RarityCore.LOGGER.info("Created default client config file: {}", (Object)CLIENT_CONFIG_FILE);
        }
        catch (IOException e) {
            RarityCore.LOGGER.error("Cannot create default client config file: {}", (Object)CLIENT_CONFIG_FILE, (Object)e);
        }
    }

    public static void saveClientConfig() {
        JsonObject configObject = new JsonObject();
        configObject.addProperty("enableItemBorderRendering", Boolean.valueOf(enableItemBorderRendering));
        configObject.addProperty("itemBorderStyle", (Number)itemBorderStyle);
        configObject.addProperty("useTextureBorder", Boolean.valueOf(useTextureBorder));
        configObject.addProperty("enableItemNameColor", Boolean.valueOf(enableItemNameColor));
        configObject.addProperty("enableTooltipInsert", Boolean.valueOf(enableTooltipInsert));
        configObject.addProperty("enableItemBackgroundRendering", Boolean.valueOf(enableItemBackgroundRendering));
        try (FileWriter writer = new FileWriter(CLIENT_CONFIG_FILE.toString());){
            GSON.toJson((JsonElement)configObject, (Appendable)writer);
            RarityCore.LOGGER.info("Client config saved: enableItemBorderRendering={}, itemBorderStyle={}, useTextureBorder={}, enableItemNameColor={}, enableTooltipInsert={}, enableItemBackgroundRendering={}", new Object[]{enableItemBorderRendering, itemBorderStyle, useTextureBorder, enableItemNameColor, enableTooltipInsert, enableItemBackgroundRendering});
        }
        catch (IOException e) {
            RarityCore.LOGGER.error("Cannot save client config file: {}", (Object)CLIENT_CONFIG_FILE, (Object)e);
        }
    }

    public static boolean isValidRarity(int rarity) {
        return rarity >= 1 && rarity <= 7;
    }

    public static boolean isEnableItemBorderRendering() {
        return enableItemBorderRendering;
    }

    public static void setEnableItemBorderRendering(boolean enable) {
        enableItemBorderRendering = enable;
    }

    public static int getItemBorderStyle() {
        return itemBorderStyle;
    }

    public static void setItemBorderStyle(int style) {
        itemBorderStyle = style;
    }

    public static boolean isUseTextureBorder() {
        return useTextureBorder;
    }

    public static void setUseTextureBorder(boolean useTexture) {
        useTextureBorder = useTexture;
    }

    public static boolean isEnableItemNameColor() {
        return enableItemNameColor;
    }

    public static void setEnableItemNameColor(boolean enable) {
        enableItemNameColor = enable;
    }

    public static boolean isEnableTooltipInsert() {
        return enableTooltipInsert;
    }

    public static void setEnableTooltipInsert(boolean enable) {
        enableTooltipInsert = enable;
    }

    public static boolean isEnableItemBackgroundRendering() {
        return enableItemBackgroundRendering;
    }

    public static void setEnableItemBackgroundRendering(boolean enable) {
        enableItemBackgroundRendering = enable;
    }
}

