/*
 * Decompiled with CFR 0.152.
 */
package org.yanbwe.raritycore.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import org.yanbwe.raritycore.RarityCore;
import org.yanbwe.raritycore.config.ConfigManager;
import org.yanbwe.raritycore.registry.RarityRegistry;

public class RarityConfigLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void loadConfigRarityData() {
        Path configDir = ConfigManager.getConfigDirPath();
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            RarityCore.LOGGER.error("Cannot create config directory: {}", (Object)configDir, (Object)e);
            return;
        }
        Path configFile = ConfigManager.getFinalRarityConfigPath();
        if (!Files.exists(configFile, new LinkOption[0])) {
            RarityConfigLoader.createDefaultConfig(configFile);
        }
        RarityConfigLoader.loadRarityDataFromFile(configFile);
    }

    private static void loadRarityDataFromFile(Path configFile) {
        try (BufferedReader reader = Files.newBufferedReader(configFile);){
            JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (jsonObject != null) {
                for (String itemIdString : jsonObject.keySet()) {
                    JsonElement rarityElement = jsonObject.get(itemIdString);
                    if (!rarityElement.isJsonPrimitive() || !rarityElement.getAsJsonPrimitive().isNumber()) continue;
                    int rarity = rarityElement.getAsInt();
                    ResourceLocation itemId = new ResourceLocation(itemIdString);
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
                    if (item == null || itemId.equals((Object)ForgeRegistries.ITEMS.getDefaultKey())) continue;
                    RarityRegistry.register(item, rarity, false);
                }
            }
        }
        catch (IOException e) {
            RarityCore.LOGGER.error("Cannot read config file: {}", (Object)configFile, (Object)e);
        }
        catch (JsonParseException e) {
            RarityCore.LOGGER.error("Config file format error: {}", (Object)configFile.toString(), (Object)e);
            try {
                RarityConfigLoader.createDefaultConfig(configFile);
            }
            catch (Exception ex) {
                RarityCore.LOGGER.error("Cannot create default config file: {}", (Object)configFile, (Object)ex);
            }
        }
    }

    private static void createDefaultConfig(Path configFile) {
        JsonObject configObject = new JsonObject();
        try (FileWriter writer = new FileWriter(configFile.toFile());){
            GSON.toJson((JsonElement)configObject, (Appendable)writer);
        }
        catch (IOException e) {
            RarityCore.LOGGER.error("Cannot create default config file: {}", (Object)configFile, (Object)e);
        }
    }
}

