/*
 * Decompiled with CFR 0.152.
 */
package org.yanbwe.raritycore.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import org.yanbwe.raritycore.RarityCore;
import org.yanbwe.raritycore.config.RarityConfigLoader;
import org.yanbwe.raritycore.registry.RarityRegistry;

public class RarityDataLoader
extends SimpleJsonResourceReloadListener {
    public static final RarityDataLoader INSTANCE = new RarityDataLoader();

    public RarityDataLoader() {
        super(new Gson(), "rarity");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            ResourceLocation location = entry.getKey();
            JsonElement element = entry.getValue();
            if (element.isJsonObject()) {
                JsonObject jsonObject = element.getAsJsonObject();
                for (Map.Entry itemEntry : jsonObject.entrySet()) {
                    String itemIdString = (String)itemEntry.getKey();
                    JsonElement rarityElement = (JsonElement)itemEntry.getValue();
                    if (rarityElement.isJsonPrimitive() && rarityElement.getAsJsonPrimitive().isNumber()) {
                        int rarity = rarityElement.getAsInt();
                        ResourceLocation itemId = new ResourceLocation(itemIdString);
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
                        if (item == null || itemId.equals((Object)ForgeRegistries.ITEMS.getDefaultKey())) {
                            RarityCore.LOGGER.warn("Unknown item '{}' in rarity data file '{}'", (Object)itemIdString, (Object)location);
                            continue;
                        }
                        if (rarity < 1 || rarity > 7) {
                            RarityCore.LOGGER.warn("Invalid rarity value {} for item '{}' in rarity data file '{}'", new Object[]{rarity, itemIdString, location});
                            continue;
                        }
                        RarityRegistry.register(item, rarity);
                        continue;
                    }
                    RarityCore.LOGGER.warn("Invalid rarity data format for item '{}' in rarity data file '{}'", itemEntry.getKey(), (Object)location);
                }
                continue;
            }
            RarityCore.LOGGER.warn("Invalid format in rarity data file '{}', expected JSON object", (Object)location);
        }
        RarityConfigLoader.loadConfigRarityData();
        RarityRegistry.syncIncrementalChangesToClients();
    }
}

