/*
 * Decompiled with CFR 0.152.
 */
package org.yanbwe.raritycore.mixin;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.yanbwe.raritycore.registry.RarityRegistry;
import org.yanbwe.raritycore.util.RarityColorUtil;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Inject(method={"getHoverName"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyHoverName(CallbackInfoReturnable<Component> cir) {
        ItemStack stack = (ItemStack)this;
        Item item = stack.m_41720_();
        Integer rarity = RarityRegistry.getRarity(item);
        if (rarity == null) {
            return;
        }
        if (rarity < 1) {
            rarity = 1;
        } else if (rarity > 7) {
            rarity = 7;
        }
        if (rarity == 1) {
            return;
        }
        ChatFormatting color = RarityColorUtil.getRarityChatColor(rarity);
        Component originalName = (Component)cir.getReturnValue();
        cir.setReturnValue((Object)originalName.m_6881_().m_130940_(color));
    }

    private ChatFormatting getRarityColor(int rarity) {
        return RarityColorUtil.getRarityChatColor(rarity);
    }
}

