/*
 * Decompiled with CFR 0.152.
 */
package org.yanbwe.raritycore.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import org.yanbwe.raritycore.network.ChangeOperation;
import org.yanbwe.raritycore.registry.RarityRegistry;

public class IncrementalSyncPacket {
    public static final String PROTOCOL_VERSION = "1.0";
    public static SimpleChannel INSTANCE;
    private List<ChangeOperation> changeOperations;

    public static void initialize() {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("raritycore", "incremental_sync"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        INSTANCE.messageBuilder(IncrementalSyncPacket.class, 0).encoder(IncrementalSyncPacket::encode).decoder(IncrementalSyncPacket::new).consumerMainThread(IncrementalSyncPacket::handle).add();
    }

    public IncrementalSyncPacket(List<ChangeOperation> changeOperations) {
        this.changeOperations = changeOperations;
    }

    public IncrementalSyncPacket(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.changeOperations = new ArrayList<ChangeOperation>();
        for (int i = 0; i < size; ++i) {
            int opType = buf.readInt();
            String itemIdStr = buf.m_130277_();
            ResourceLocation itemId = new ResourceLocation(itemIdStr);
            Integer rarity = null;
            boolean hasRarity = buf.readBoolean();
            if (hasRarity) {
                rarity = buf.readInt();
            }
            ChangeOperation.OperationType type = ChangeOperation.OperationType.values()[opType];
            this.changeOperations.add(new ChangeOperation(type, itemId, rarity));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.changeOperations.size());
        for (ChangeOperation op : this.changeOperations) {
            buf.writeInt(op.getType().ordinal());
            buf.m_130070_(op.getItemId().toString());
            buf.writeBoolean(op.getRarity() != null);
            if (op.getRarity() == null) continue;
            buf.writeInt(op.getRarity().intValue());
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            for (ChangeOperation op : this.changeOperations) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(op.getItemId());
                switch (op.getType()) {
                    case ADD: 
                    case UPDATE: {
                        if (item == null || op.getItemId().equals((Object)ForgeRegistries.ITEMS.getDefaultKey())) break;
                        RarityRegistry.ITEM_RARITY_MAP.put(op.getItemId(), op.getRarity());
                        break;
                    }
                    case DELETE: {
                        RarityRegistry.ITEM_RARITY_MAP.remove(op.getItemId());
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
        return true;
    }

    public List<ChangeOperation> getChangeOperations() {
        return this.changeOperations;
    }
}

