/*
 * Decompiled with CFR 0.152.
 */
package org.yanbwe.raritycore.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import org.yanbwe.raritycore.registry.RarityRegistry;

public class RaritySyncPacket {
    public static final String PROTOCOL_VERSION = "1.0";
    public static SimpleChannel INSTANCE;
    private Map<ResourceLocation, Integer> rarityData;

    public static void initialize() {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("raritycore", "rarity_sync"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        INSTANCE.messageBuilder(RaritySyncPacket.class, 0).encoder(RaritySyncPacket::encode).decoder(RaritySyncPacket::new).consumerMainThread(RaritySyncPacket::handle).add();
    }

    public RaritySyncPacket(Map<ResourceLocation, Integer> rarityData) {
        this.rarityData = rarityData;
    }

    public RaritySyncPacket(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.rarityData = new HashMap<ResourceLocation, Integer>();
        for (int i = 0; i < size; ++i) {
            String key = buf.m_130277_();
            int value = buf.readInt();
            this.rarityData.put(new ResourceLocation(key), value);
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.rarityData.size());
        for (Map.Entry<ResourceLocation, Integer> entry : this.rarityData.entrySet()) {
            buf.m_130070_(entry.getKey().toString());
            buf.writeInt(entry.getValue().intValue());
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            RarityRegistry.ITEM_RARITY_MAP.clear();
            for (Map.Entry<ResourceLocation, Integer> entry : this.rarityData.entrySet()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(entry.getKey());
                if (item == null || entry.getKey().equals((Object)ForgeRegistries.ITEMS.getDefaultKey())) continue;
                RarityRegistry.ITEM_RARITY_MAP.put(entry.getKey(), entry.getValue());
            }
        });
        ctx.get().setPacketHandled(true);
        return true;
    }
}

