/*
 * Decompiled with CFR 0.152.
 */
package org.yanbwe.raritycore.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.yanbwe.raritycore.network.ChangeOperation;
import org.yanbwe.raritycore.network.IncrementalSyncPacket;
import org.yanbwe.raritycore.network.RaritySyncPacket;

public class RarityRegistry {
    public static final ConcurrentHashMap<ResourceLocation, Integer> ITEM_RARITY_MAP = new ConcurrentHashMap();
    private static final List<ChangeOperation> CHANGE_OPERATIONS_BUFFER = new ArrayList<ChangeOperation>();

    public static void register(@Nullable Item item, int rarity) {
        RarityRegistry.register(item, rarity, true);
    }

    public static void register(@Nullable Item item, int rarity, boolean syncToClients) {
        ResourceLocation itemId;
        if (item != null && (itemId = ForgeRegistries.ITEMS.getKey((Object)item)) != null && !itemId.equals((Object)ForgeRegistries.ITEMS.getDefaultKey())) {
            Integer oldRarity = ITEM_RARITY_MAP.put(itemId, rarity);
            if (syncToClients) {
                if (oldRarity == null) {
                    CHANGE_OPERATIONS_BUFFER.add(new ChangeOperation(ChangeOperation.OperationType.ADD, itemId, rarity));
                } else {
                    CHANGE_OPERATIONS_BUFFER.add(new ChangeOperation(ChangeOperation.OperationType.UPDATE, itemId, rarity));
                }
                RarityRegistry.syncRarityToClients();
            }
        }
    }

    public static void unregister(@Nullable Item item, boolean syncToClients) {
        ResourceLocation itemId;
        if (item != null && (itemId = ForgeRegistries.ITEMS.getKey((Object)item)) != null && !itemId.equals((Object)ForgeRegistries.ITEMS.getDefaultKey())) {
            Integer removedRarity = ITEM_RARITY_MAP.remove(itemId);
            if (syncToClients) {
                if (removedRarity != null) {
                    CHANGE_OPERATIONS_BUFFER.add(new ChangeOperation(ChangeOperation.OperationType.DELETE, itemId, null));
                }
                RarityRegistry.syncRarityToClients();
            }
        }
    }

    public static void syncRarityToClients() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            HashMap<ResourceLocation, Integer> currentData = new HashMap<ResourceLocation, Integer>(ITEM_RARITY_MAP);
            RaritySyncPacket packet = new RaritySyncPacket(currentData);
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                RaritySyncPacket.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
            }
        }
    }

    public static void syncIncrementalChangesToClients() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && !CHANGE_OPERATIONS_BUFFER.isEmpty()) {
            IncrementalSyncPacket packet = new IncrementalSyncPacket(new ArrayList<ChangeOperation>(CHANGE_OPERATIONS_BUFFER));
            CHANGE_OPERATIONS_BUFFER.clear();
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                IncrementalSyncPacket.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
            }
        }
    }

    public static int getPendingChangeCount() {
        return CHANGE_OPERATIONS_BUFFER.size();
    }

    public static void clearChangeBuffer() {
        CHANGE_OPERATIONS_BUFFER.clear();
    }

    @NotNull
    public static Integer getRarity(@Nullable Item item) {
        ResourceLocation itemId;
        if (item != null && (itemId = ForgeRegistries.ITEMS.getKey((Object)item)) != null && !itemId.equals((Object)ForgeRegistries.ITEMS.getDefaultKey())) {
            Integer configuredRarity = ITEM_RARITY_MAP.get(itemId);
            if (configuredRarity != null) {
                return configuredRarity;
            }
            ItemStack tempStack = new ItemStack((ItemLike)item);
            Rarity vanillaRarity = tempStack.m_41791_();
            if (vanillaRarity == Rarity.UNCOMMON) {
                return 3;
            }
            if (vanillaRarity == Rarity.RARE) {
                return 4;
            }
            if (vanillaRarity == Rarity.EPIC) {
                return 5;
            }
        }
        return 1;
    }
}

