/*
 * Decompiled with CFR 0.152.
 */
package com.neuromuser.loopingworld;

import com.neuromuser.loopingworld.BorderTouchDetector;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2767;
import net.minecraft.class_2784;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3486;

public class LoopingWorld
implements ModInitializer {
    private static final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TICKS = 10L;

    public void onInitialize() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            long tick = server.method_3780();
            for (class_3222 player : server.method_3760().method_14571()) {
                if (!BorderTouchDetector.isTouchingBorder((class_1657)player)) continue;
                this.teleport(player, tick);
            }
        });
    }

    private void teleport(class_3222 player, long tick) {
        int bz;
        UUID id = player.method_5667();
        Long last = cooldowns.get(id);
        if (last != null && tick - last < 10L) {
            return;
        }
        class_3218 world = player.method_14220();
        class_2784 border = world.method_8621();
        double x = player.method_23317();
        double z = player.method_23321();
        double half = border.method_11965() / 2.0;
        double cx = border.method_11964();
        double cz = border.method_11980();
        double ox = x - cx;
        double oz = z - cz;
        if (Math.abs(ox) > half || Math.abs(oz) > half) {
            return;
        }
        double nx = cx - ox + Math.signum(ox);
        double nz = cz - oz + Math.signum(oz);
        int bx = (int)Math.floor(nx);
        int y = this.getSafeSurfaceY(world, bx, bz = (int)Math.floor(nz));
        if (y <= world.method_31607()) {
            this.play(player, class_3417.field_15008, x, player.method_23318(), z);
            cooldowns.put(id, tick);
            return;
        }
        double fx = (double)bx + 0.5;
        double fz = (double)bz + 0.5;
        this.play(player, class_3417.field_14915, x, player.method_23318(), z);
        player.method_14251(world, fx, (double)y, fz, player.method_36454(), player.method_36455());
        this.play(player, class_3417.field_14915, fx, y, fz);
        player.method_18800(0.0, 0.0, 0.0);
        player.field_6017 = 0.0f;
        cooldowns.put(id, tick);
    }

    private int getSafeSurfaceY(class_3218 world, int x, int z) {
        int surface = world.method_8624(class_2902.class_2903.field_13197, x, z);
        class_2338 groundPos = new class_2338(x, surface - 1, z);
        class_2338 feetPos = new class_2338(x, surface, z);
        class_2338 headPos = feetPos.method_10084();
        if (surface <= world.method_31607()) {
            return world.method_31607() - 1;
        }
        class_2680 ground = world.method_8320(groundPos);
        class_2680 feet = world.method_8320(feetPos);
        class_2680 head = world.method_8320(headPos);
        if (this.isHazardous(ground)) {
            return world.method_31607() - 1;
        }
        if (!this.isClear(feet, world, feetPos)) {
            return world.method_31607() - 1;
        }
        if (!this.isClear(head, world, headPos)) {
            return world.method_31607() - 1;
        }
        return surface;
    }

    private boolean isClear(class_2680 state, class_3218 world, class_2338 pos) {
        if (state.method_26215()) {
            return true;
        }
        if (!state.method_26227().method_15769()) {
            return false;
        }
        return state.method_26220((class_1922)world, pos).method_1110();
    }

    private boolean isHazardous(class_2680 state) {
        if (state.method_26227().method_15767(class_3486.field_15518)) {
            return true;
        }
        if (state.method_26164(class_3481.field_21952)) {
            return true;
        }
        return state.method_26204() == class_2246.field_10092 || state.method_26204() == class_2246.field_17350 || state.method_26204() == class_2246.field_23860 || state.method_26204() == class_2246.field_10029 || state.method_26204() == class_2246.field_16999 || state.method_26204() == class_2246.field_10606 || state.method_26204() == class_2246.field_27879;
    }

    private void play(class_3222 player, class_3414 sound, double x, double y, double z) {
        player.field_13987.method_14364((class_2596)new class_2767(sound, class_3419.field_15248, x, y, z, 1.0f, 1.0f, player.method_14220().field_9229.method_43055()));
    }
}

