/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.eternal_tales.init.EternalTalesModScreens;
import net.eternal_tales.network.MiguelStartButtonMessage;
import net.eternal_tales.procedures.ProvideMiguelModelProcedure;
import net.eternal_tales.world.inventory.MiguelStartMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;

public class MiguelStartScreen
extends AbstractContainerScreen<MiguelStartMenu>
implements EternalTalesModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    Button button_okay;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"eternal_tales:textures/screens/miguel_start.png");

    public MiguelStartScreen(MiguelStartMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 235;
        this.imageHeight = 206;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Entity entity = ProvideMiguelModelProcedure.execute((LevelAccessor)this.world);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            EternalTalesModScreens.renderEntityInInventoryFollowsAngle(guiGraphics, this.leftPos + 37, this.topPos + 74, 30, 0.0f + (float)Math.atan((double)(this.leftPos + 37 - mouseX) / 40.0), (float)Math.atan((double)(this.topPos + 25 - mouseY) / 40.0), livingEntity);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.eternal_tales.miguel_start.label_hi_my_name_is_miguel_and_im"), 63, 9, -16777216, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.eternal_tales.miguel_start.label_storyteller_im_the_person_who"), 63, 18, -16777216, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.eternal_tales.miguel_start.label_knows_everything_about"), 63, 27, -16777216, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.eternal_tales.miguel_start.label_everything_and_i_can_help_you"), 63, 36, -16777216, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.eternal_tales.miguel_start.label_pass_the_mod_if_you_want_to_of"), 63, 45, -16777216, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.eternal_tales.miguel_start.label_course"), 63, 54, -16777216, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.eternal_tales.miguel_start.label_i_have_a_job_for_you"), 63, 63, -16777216, false);
    }

    public void init() {
        super.init();
        this.button_okay = Button.builder((Component)Component.translatable((String)"gui.eternal_tales.miguel_start.button_okay"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new MiguelStartButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            MiguelStartButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }).bounds(this.leftPos + 9, this.topPos + 171, 150, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_okay);
    }
}

