/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelTerribleTree<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"model_terrible_tree"), "main");
    public final ModelPart leftleg;
    public final ModelPart rightleg;
    public final ModelPart leftarm;
    public final ModelPart rightarm;
    public final ModelPart body;
    public final ModelPart head;

    public ModelTerribleTree(ModelPart root) {
        this.leftleg = root.getChild("leftleg");
        this.rightleg = root.getChild("rightleg");
        this.leftarm = root.getChild("leftarm");
        this.rightarm = root.getChild("rightarm");
        this.body = root.getChild("body");
        this.head = root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition leftleg = partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(91, 97).addBox(-4.0f, 15.0f, -4.0f, 8.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(99, 74).addBox(-3.0f, -1.0f, -3.0f, 6.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-7.0f, (float)0.0f));
        PartDefinition rightleg = partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(128, 99).addBox(-4.0f, 15.0f, -4.0f, 8.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(136, 77).addBox(-3.0f, -1.0f, -3.0f, 6.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-7.0f, (float)0.0f));
        PartDefinition leftarm = partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create(), PartPose.offset((float)-8.0f, (float)-36.0f, (float)0.0f));
        PartDefinition leftarmtop = leftarm.addOrReplaceChild("leftarmtop", CubeListBuilder.create().texOffs(101, 0).addBox(-6.0f, -3.0f, -3.0f, 6.0f, 20.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(88, 55).addBox(-18.9658f, -5.4779f, 0.0f, 15.0f, 18.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition leftarmbottom = leftarm.addOrReplaceChild("leftarmbottom", CubeListBuilder.create().texOffs(94, 27).addBox(-5.0f, -1.9848f, -4.1736f, 8.0f, 20.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)17.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create(), PartPose.offset((float)8.0f, (float)-36.0f, (float)0.0f));
        PartDefinition rightarmtop = rightarm.addOrReplaceChild("rightarmtop", CubeListBuilder.create().texOffs(128, 56).addBox(0.7389f, -5.0171f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(136, 0).addBox(1.0f, -3.0f, -3.0f, 6.0f, 20.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition rightarmbottom = rightarm.addOrReplaceChild("rightarmbottom", CubeListBuilder.create().texOffs(128, 27).addBox(-3.0f, -2.0f, -4.0f, 8.0f, 20.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)17.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 81).addBox(-7.0f, 4.0f, -3.0f, 14.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 57).addBox(-8.0f, -12.0f, -4.0f, 16.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(40, 0).addBox(-3.0f, -14.0f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-28.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -15.0f, -5.0f, 10.0f, 17.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(40, 8).addBox(-1.0f, -6.0f, -7.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-43.0f, (float)-1.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)160, (int)160);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
    }
}

