/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelbloodsucker<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"modelbloodsucker"), "main");
    public final ModelPart head;
    public final ModelPart right_arm;
    public final ModelPart left_arm;
    public final ModelPart left_leg;
    public final ModelPart right_leg;
    public final ModelPart bb_main;

    public Modelbloodsucker(ModelPart root) {
        this.head = root.getChild("head");
        this.right_arm = root.getChild("right_arm");
        this.left_arm = root.getChild("left_arm");
        this.left_leg = root.getChild("left_leg");
        this.right_leg = root.getChild("right_leg");
        this.bb_main = root.getChild("bb_main");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)-3.0f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -5.1505f, -4.446f, 8.0f, 7.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-1.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(31, 11).addBox(-4.0f, -2.0457f, -5.0459f, 8.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.0f, -8.0457f, -5.0459f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = head.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(28, 26).mirror().addBox(0.0f, -7.5005f, -0.6291f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)-5.0f, (float)-0.22f, (float)-0.1278f, (float)0.0285f));
        PartDefinition cube_r4 = head.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(28, 18).addBox(-8.0f, -7.5005f, -0.6291f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)-5.0f, (float)-0.22f, (float)0.1278f, (float)-0.0285f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)1.0f, (float)-1.0f));
        PartDefinition cube_r5 = right_arm.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(16, 32).addBox(-1.8092f, 0.5855f, -1.5298f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)4.0f, (float)1.0f, (float)-0.2489f, (float)-0.0663f, (float)-0.0264f));
        PartDefinition cube_r6 = right_arm.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(0, 32).addBox(-4.0f, -2.0381f, -2.8716f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3538f, (float)0.0406f, (float)0.2423f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)2.0f, (float)-4.0f));
        PartDefinition cube_r7 = left_arm.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(16, 32).mirror().addBox(-2.3171f, 0.6938f, -1.7562f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)3.0f, (float)4.0f, (float)2.0f, (float)-0.4342f, (float)0.0514f, (float)0.0344f));
        PartDefinition cube_r8 = left_arm.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(0, 32).addBox(0.0f, -1.0419f, -2.9587f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)2.0f, (float)0.3046f, (float)0.0568f, (float)-0.1608f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition cube_r9 = left_leg.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(16, 42).mirror().addBox(0.0f, -1.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)6.0f, (float)0.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r10 = left_leg.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(0, 42).mirror().addBox(0.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.01f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition cube_r11 = right_leg.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(16, 42).addBox(-4.0f, -1.0f, -3.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)6.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r12 = right_leg.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(0, 42).addBox(-4.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition bb_main = partdefinition.addOrReplaceChild("bb_main", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r13 = bb_main.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(0, 14).addBox(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)0.0f, (float)0.3043f, (float)-0.0262f, (float)0.0832f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.bb_main.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.right_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.left_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

